/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.roundrussell.utility;

import java.util.Collection;
import java.util.List;

public abstract class BinaryCondition<T> {
    public abstract boolean isSatisfiedBy(T var1, T var2);

    public boolean isPairwiseSatisfiedBy(Collection<T> values) {
        for (T value1 : values) {
            for (T value2 : values) {
                if (this.isSatisfiedBy(value1, value2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSatisfiedBetween(List<T> values1, List<T> values2) {
        int ii = 0;
        while (ii < Math.min(values1.size(), values2.size())) {
            if (!this.isSatisfiedBy(values1.get(ii), values2.get(ii))) {
                return false;
            }
            ++ii;
        }
        return true;
    }
}

