/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.visualization.roundrussell.utility;

import edu.iu.nwb.visualization.roundrussell.utility.BinaryCondition;

public class RelativeDifferenceLimit
extends BinaryCondition<Double> {
    private double tolerance;

    public RelativeDifferenceLimit(double tolerance) {
        this.tolerance = tolerance;
    }

    @Override
    public boolean isSatisfiedBy(Double x1, Double x2) {
        return this.relativeDifference(x1, x2) <= this.tolerance;
    }

    private double relativeDifference(double x1, double x2) {
        if (x1 == x2) {
            return 0.0;
        }
        double absoluteDifference = Math.abs(x1 - x2);
        double maxOfAbsolutes = Math.max(Math.abs(x1), Math.abs(x2));
        return absoluteDifference / maxOfAbsolutes;
    }
}

