/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.converter.psraster.jpg.jpgreader;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import javax.imageio.ImageIO;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public class JPGReaderAlgorithm
implements Algorithm {
    private Data[] data;
    private Dictionary parameters;
    private CIShellContext context;

    public JPGReaderAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        File jpgFile = (File)this.data[0].getData();
        BufferedImage loadedImage = null;
        try {
            loadedImage = ImageIO.read(jpgFile);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException((Throwable)e);
        }
        BasicData loadedImageData = new BasicData((Object)loadedImage, "java.awt.image.BufferedImage");
        Dictionary loadedImageMetadata = loadedImageData.getMetadata();
        loadedImageMetadata.put("Label", "Image: " + jpgFile.getAbsolutePath());
        loadedImageMetadata.put("Type", "Raster Image");
        return new Data[]{loadedImageData};
    }
}

