/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.converter.psraster.postscript.postscriptrenderer;

import edu.iu.sci2.converter.psraster.postscript.postscriptrenderer.VirtualDeviceFix;
import edu.iu.sci2.converter.psraster.postscript.postscriptrenderer.utility.DimensionExtractor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.freehep.postscript.PSDevice;
import org.freehep.postscript.PSInputFile;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.Processor;
import org.osgi.service.log.LogService;

public class PostScriptRendererAlgorithm
implements Algorithm {
    private static Dimension DEFAULT_IMAGE_DIMENSIONS = new Dimension(800, 600);
    private Data[] data;
    private Dictionary parameters;
    private CIShellContext context;
    LogService logger;

    public PostScriptRendererAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        File postScriptFile = (File)this.data[0].getData();
        String postScriptFileName = postScriptFile.getAbsolutePath();
        this.logger.log(3, "Rendering PostScript.  May take a few moments...");
        Dimension imageDimensions = DimensionExtractor.determineImageDimensions(postScriptFile, this.logger);
        System.out.println("Using dimensions " + imageDimensions.width + ", " + imageDimensions.height);
        BufferedImage bufferedImage = this.renderPostScriptFileToBufferedImage(postScriptFileName, imageDimensions.width, imageDimensions.height);
        BasicData bufferedImageData = new BasicData((Object)bufferedImage, "java.awt.image.BufferedImage");
        return new Data[]{bufferedImageData};
    }

    public BufferedImage renderPostScriptFileToBufferedImage(String postScriptFileName, int width, int height) throws AlgorithmExecutionException {
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D bufferedImageGraphics = bufferedImage.createGraphics();
        try {
            VirtualDeviceFix postScriptDeviceToRenderTo = new VirtualDeviceFix(bufferedImageGraphics, new Dimension(width, height));
            Processor postScriptProcessor = new Processor((PSDevice)postScriptDeviceToRenderTo, false);
            postScriptProcessor.setData((PSObject)new PSInputFile(postScriptFileName));
            postScriptProcessor.process();
        }
        catch (Exception e) {
            throw new AlgorithmExecutionException("Failed to render PostScript file '" + postScriptFileName + "' for the following reason:\r\n" + e.getMessage(), (Throwable)e);
        }
        return bufferedImage;
    }
}

