/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.converter.psraster.postscript.postscriptrenderer.utility;

import edu.iu.sci2.converter.psraster.postscript.postscriptrenderer.utility.DimensionDeterminingException;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.log.LogService;

public class DimensionExtractor {
    private static Dimension DEFAULT_IMAGE_DIMENSIONS = new Dimension(800, 600);
    private static int CHECK_X_LINES_FOR_BOUNDING_BOX_BEFORE_GIVING_UP = 40;
    private static Pattern boundingBoxLinePattern = DimensionExtractor.createBoundingBoxLineRegexPattern();
    private static int NUM_NUMBERS_IN_PATTERN = 4;

    public static Dimension determineImageDimensions(File postScriptFile, LogService logger) {
        try {
            BufferedReader postScriptReader = new BufferedReader(new FileReader(postScriptFile));
            String postScriptLine = null;
            int numLinesChecked = 0;
            while (true) {
                Matcher lineMatcher;
                if ((postScriptLine = postScriptReader.readLine()) == null) {
                    DimensionExtractor.throwExceptionForNoBoundingBoxLineInFile();
                }
                if ((lineMatcher = boundingBoxLinePattern.matcher(postScriptLine)).matches()) {
                    String boundingBoxLine = postScriptLine;
                    Dimension boundingBoxDimensions = DimensionExtractor.extractDimensions(lineMatcher, boundingBoxLine);
                    return boundingBoxDimensions;
                }
                if (++numLinesChecked <= CHECK_X_LINES_FOR_BOUNDING_BOX_BEFORE_GIVING_UP) continue;
                DimensionExtractor.throwExceptionForBoundingBoxLineNotInHeader();
            }
        }
        catch (DimensionDeterminingException e) {
            logger.log(2, e.getMessage(), (Throwable)e);
            DimensionExtractor.logThatWeArereUsingTheDefaultDimensions(logger);
            return DEFAULT_IMAGE_DIMENSIONS;
        }
        catch (FileNotFoundException e) {
            String message = "Could not find the PostScript file '" + postScriptFile.getAbsolutePath() + "'" + " in order to determine the PostScript image's dimensions.";
            logger.log(2, message, (Throwable)e);
            DimensionExtractor.logThatWeArereUsingTheDefaultDimensions(logger);
            return DEFAULT_IMAGE_DIMENSIONS;
        }
        catch (IOException e) {
            String message = "Encountered a problem while reading the PostScript file '" + postScriptFile.getAbsolutePath() + "'" + " in order to determine the PostScript image's dimensions.";
            logger.log(2, message, (Throwable)e);
            DimensionExtractor.logThatWeArereUsingTheDefaultDimensions(logger);
            return DEFAULT_IMAGE_DIMENSIONS;
        }
        catch (NumberFormatException e) {
            String message = "Could not parse the image dimension information for the PostScript file '" + postScriptFile.getAbsolutePath() + "'.";
            logger.log(2, message, (Throwable)e);
            DimensionExtractor.logThatWeArereUsingTheDefaultDimensions(logger);
            return DEFAULT_IMAGE_DIMENSIONS;
        }
        catch (Exception e) {
            String message = "Encountered an unexpected exception while looking for image dimension information inside the PostScript file '" + postScriptFile.getAbsolutePath() + "'.";
            logger.log(2, message, (Throwable)e);
            DimensionExtractor.logThatWeArereUsingTheDefaultDimensions(logger);
            return DEFAULT_IMAGE_DIMENSIONS;
        }
    }

    private static Dimension extractDimensions(Matcher boundingBoxMatcher, String boundingBoxLine) throws DimensionDeterminingException {
        if (boundingBoxMatcher.groupCount() != NUM_NUMBERS_IN_PATTERN) {
            DimensionExtractor.throwExceptionForInvalidBoundingBoxLine(boundingBoxLine);
        }
        float bottomLeftX = Float.parseFloat(boundingBoxMatcher.group(1));
        float bottomLeftY = Float.parseFloat(boundingBoxMatcher.group(2));
        float topRightX = Float.parseFloat(boundingBoxMatcher.group(3));
        float topRightY = Float.parseFloat(boundingBoxMatcher.group(4));
        float imageWidth = topRightX - bottomLeftX;
        float imageHeight = topRightY - bottomLeftY;
        int roundedImageWidth = DimensionExtractor.roundUp(imageWidth);
        int roundedImageHeight = DimensionExtractor.roundUp(imageHeight);
        if (roundedImageWidth < 0 || roundedImageHeight < 0) {
            DimensionExtractor.throwExceptionForNegativeBoundingBoxDimensions(roundedImageWidth, roundedImageHeight);
        }
        Dimension boundingBoxDimensions = new Dimension(roundedImageWidth, roundedImageHeight);
        return boundingBoxDimensions;
    }

    private static void throwExceptionForInvalidBoundingBoxLine(String boundingBoxLine) throws DimensionDeterminingException {
        String message = "Could not determine intended image dimensions from PostScript file.";
        throw new DimensionDeterminingException(message);
    }

    private static void throwExceptionForBoundingBoxLineNotInHeader() throws DimensionDeterminingException {
        String message = "No dimension information in header of PostScript file(Could not find a BoundingBox line in the first " + CHECK_X_LINES_FOR_BOUNDING_BOX_BEFORE_GIVING_UP + " lines.)";
        throw new DimensionDeterminingException(message);
    }

    private static void throwExceptionForNegativeBoundingBoxDimensions(float imageWidth, float imageHeight) throws DimensionDeterminingException {
        String message = "Postscript file contains invalid negative image dimensions '(" + imageWidth + ", " + imageHeight + ")'.";
        throw new DimensionDeterminingException(message);
    }

    private static void throwExceptionForNoBoundingBoxLineInFile() throws DimensionDeterminingException {
        String message = "Postscript file does not contain image dimensions information.";
        throw new DimensionDeterminingException(message);
    }

    private static void logThatWeArereUsingTheDefaultDimensions(LogService logger) {
        String message = "Using default dimensions '(" + DimensionExtractor.DEFAULT_IMAGE_DIMENSIONS.width + "," + DimensionExtractor.DEFAULT_IMAGE_DIMENSIONS.height + ")'.";
        logger.log(3, message);
    }

    private static Pattern createBoundingBoxLineRegexPattern() {
        String optionalDecimalPoint = "\\.?";
        String aNumber = "[-+]?[0-9]*" + optionalDecimalPoint + "[0-9]+";
        String boundingBoxLineRegex = "^.*BoundingBox:\\s*" + DimensionExtractor.captureGroup(aNumber) + "\\s+" + DimensionExtractor.captureGroup(aNumber) + "\\s+" + DimensionExtractor.captureGroup(aNumber) + "\\s+" + DimensionExtractor.captureGroup(aNumber) + ".*" + "$";
        Pattern localBoundingBoxLinePattern = Pattern.compile(boundingBoxLineRegex, 2);
        return localBoundingBoxLinePattern;
    }

    private static String captureGroup(String regex) {
        return "(" + regex + ")";
    }

    private static int roundUp(float number) {
        return Math.round(number + 0.5f);
    }

    public static void main(String[] args) {
        Pattern p = DimensionExtractor.createBoundingBoxLineRegexPattern();
        Matcher m = p.matcher("%%BoundingBox: -300 +300.0 +3210 11874.993");
        if (m.matches()) {
            System.out.println("Matches");
        } else {
            System.out.println("No match");
        }
    }
}

