/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.filtering.topn;

import edu.iu.sci2.filtering.topncommon.TopNUtilities;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.ColumnNotFoundException;
import prefuse.data.Table;

public class TopNAlgorithm
implements Algorithm {
    private Data[] data;
    private Dictionary parameters;
    private CIShellContext context;
    private int topN;
    private String columnToSortBy;
    private boolean isDescending;

    public TopNAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
        this.topN = (Integer)parameters.get("topN");
        this.columnToSortBy = (String)parameters.get("columnToSortBy");
        this.isDescending = (Boolean)parameters.get("isDescending");
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Data inData = this.data[0];
        Table table = (Table)inData.getData();
        Table sortedTable = null;
        try {
            sortedTable = TopNUtilities.sortTableWithOnlyTopN(table, this.columnToSortBy, this.isDescending, this.topN);
        }
        catch (ColumnNotFoundException e) {
            throw new AlgorithmExecutionException((Throwable)e);
        }
        Data[] outData = this.prepareOutData(sortedTable, inData);
        return outData;
    }

    private Data[] prepareOutData(Table outTable, Data inData) {
        BasicData outData = new BasicData((Object)outTable, outTable.getClass().getName());
        Dictionary outMetaData = outData.getMetadata();
        Dictionary inMetaData = inData.getMetadata();
        String baseLabelString = "Top " + outTable.getRowCount() + " row(s) (";
        String sortingLabelString = null;
        sortingLabelString = this.isDescending ? "descending order" : "ascending order";
        outMetaData.put("Label", String.valueOf(baseLabelString) + sortingLabelString + ") (based on " + this.columnToSortBy + ") of " + inMetaData.get("Label"));
        outMetaData.put("Parent", inData);
        outMetaData.put("Type", "Table");
        return new Data[]{outData};
    }
}

