/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.filtering.topncommon;

import java.io.IOException;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.cishell.utilities.ColumnNotFoundException;
import org.cishell.utilities.MutateParameterUtilities;
import org.cishell.utilities.TableUtilities;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.util.collections.IntIterator;

public class TopNUtilities {
    public static final String TOP_N_ID = "topN";
    public static final String TOP_N_PERCENT_ID = "topNPercent";
    public static final String COLUMN_TO_SORT_BY_ID = "columnToSortBy";
    public static final String SHOULD_SORT_ID = "shouldSort";
    public static final String IS_DESCENDING_ID = "isDescending";

    public static ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition parameters) {
        BasicObjectClassDefinition newDefinition;
        ObjectClassDefinition oldDefinition = parameters;
        try {
            newDefinition = new BasicObjectClassDefinition(oldDefinition.getID(), oldDefinition.getName(), oldDefinition.getDescription(), oldDefinition.getIcon(16));
        }
        catch (IOException iOException) {
            newDefinition = new BasicObjectClassDefinition(oldDefinition.getID(), oldDefinition.getName(), oldDefinition.getDescription(), null);
        }
        Table table = (Table)data[0].getData();
        AttributeDefinition[] definitions = oldDefinition.getAttributeDefinitions(-1);
        int ii = 0;
        while (ii < definitions.length) {
            AttributeDefinition oldAttribute = definitions[ii];
            String attributeID = oldAttribute.getID();
            AttributeDefinition newAttribute = oldAttribute;
            if (attributeID.equals(COLUMN_TO_SORT_BY_ID)) {
                newAttribute = MutateParameterUtilities.formIntegerAttributeDefinition((AttributeDefinition)oldAttribute, (Table)table);
            }
            newDefinition.addAttributeDefinition(1, newAttribute);
            ++ii;
        }
        return newDefinition;
    }

    public static Table sortTableWithOnlyTopN(Table originalTable, String columnToSortBy, boolean isDescending, int topN) throws ColumnNotFoundException {
        if (originalTable.getColumnNumber(columnToSortBy) == -1) {
            throw new ColumnNotFoundException("The column '" + columnToSortBy + "' could not be found in table: " + originalTable);
        }
        if (originalTable.getRowCount() == 0 || topN <= 0) {
            return TableUtilities.createTableUsingSchema((Schema)originalTable.getSchema());
        }
        IntIterator iteratorOverSortedTableTuples = originalTable.rowsSortedBy(columnToSortBy, true);
        return TableUtilities.copyNRowsFromTableUsingIntIterator((Table)originalTable, (IntIterator)iteratorOverSortedTableTuples, (int)topN, (boolean)isDescending);
    }
}

