/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.filtering.topnpercent;

import edu.iu.sci2.filtering.topncommon.TopNUtilities;
import java.util.Dictionary;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.ColumnNotFoundException;
import prefuse.data.Table;

public class TopNPercentAlgorithm
implements Algorithm {
    private Data inputData;
    private float topNPercent;
    private String columnToSortBy;
    private boolean isDescending;

    public TopNPercentAlgorithm(Data inputData, float topNPercent, String columnToSortBy, boolean isDescending) {
        this.inputData = inputData;
        this.topNPercent = topNPercent;
        this.columnToSortBy = columnToSortBy;
        this.isDescending = isDescending;
        this.topNPercent = Math.min(1.0f, this.topNPercent);
        this.topNPercent = Math.max(0.0f, this.topNPercent);
    }

    public Data[] execute() throws AlgorithmExecutionException {
        int flooredCalculatedTopNRows;
        Table table = (Table)this.inputData.getData();
        int numTableRows = table.getRowCount();
        double calculatedTopNRows = (double)this.topNPercent * (double)numTableRows;
        int finalTopN = flooredCalculatedTopNRows = (int)calculatedTopNRows;
        if ((double)flooredCalculatedTopNRows != calculatedTopNRows) {
            finalTopN = (int)Math.round(calculatedTopNRows + 0.5);
        }
        Table sortedTable = null;
        try {
            sortedTable = TopNUtilities.sortTableWithOnlyTopN(table, this.columnToSortBy, this.isDescending, finalTopN);
        }
        catch (ColumnNotFoundException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        Data[] outData = this.prepareOutData(sortedTable, this.inputData);
        return outData;
    }

    private Data[] prepareOutData(Table outTable, Data inData) {
        BasicData outData = new BasicData((Object)outTable, outTable.getClass().getName());
        Dictionary outMetadata = outData.getMetadata();
        Dictionary inMetadata = inData.getMetadata();
        int topNPercentAsInteger = (int)(this.topNPercent * 100.0f);
        String sortingLabelString = null;
        sortingLabelString = this.isDescending ? "descending order" : "ascending order";
        String label = String.format("Top %d%% (%d rows(s)) (%s) (based on %s) of %s", topNPercentAsInteger, outTable.getRowCount(), sortingLabelString, this.columnToSortBy, inMetadata.get("Label"));
        outMetadata.put("Label", label);
        outMetadata.put("Parent", inData);
        outMetadata.put("Type", "Table");
        return new Data[]{outData};
    }
}

