/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.help.documentation;

import edu.iu.sci2.help.documentation.DocumentationDialog;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.Data;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.log.LogService;

public class Documentation
implements Algorithm {
    private LogService log;

    public Documentation(Data[] data, Dictionary parameters, CIShellContext context) {
        this.log = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            Shell parentShell = this.getParentShell();
            DocumentationRunnable documentationDialogRunnable = new DocumentationRunnable(parentShell);
            Thread documentationDialogThread = new Thread(documentationDialogRunnable);
            parentShell.getDisplay().asyncExec((Runnable)documentationDialogThread);
        }
        catch (Error e) {
            this.log(1, "Documentation Algorithm failed due to unhandled error: " + e.getMessage(), e);
        }
        return new Data[0];
    }

    private Shell getParentShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        IWorkbenchWindow window = windows[0];
        Shell parentShell = window.getShell();
        return parentShell;
    }

    private void log(int messageLevel, String message, Throwable error) {
        if (this.log != null) {
            this.log(messageLevel, message, error);
            error.printStackTrace();
        } else {
            error.printStackTrace();
        }
    }

    private class DocumentationRunnable
    implements Runnable {
        private Shell parentShell;

        public DocumentationRunnable(Shell parentShell) {
            this.parentShell = parentShell;
        }

        @Override
        public void run() {
            DocumentationDialog dialog = new DocumentationDialog(this.parentShell);
            dialog.open();
        }
    }
}

