/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.help.documentation;

import edu.iu.sci2.help.documentation.WebsiteLinkWidget;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DocumentationDialog
extends Dialog {
    private static List<Hyperlink> links = new ArrayList<Hyperlink>();
    private Shell shell;

    static {
        links.add(new Hyperlink("Main Sci2 Tool Website", "https://sci2.cns.iu.edu"));
        links.add(new Hyperlink("All Sci2 Documentation", "https://sci2.cns.iu.edu/user/documentation.php"));
        links.add(new Hyperlink("Sci2 Tutorial", "http://sci2.wiki.cns.iu.edu"));
    }

    public DocumentationDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createControls(composite);
        return composite;
    }

    private void createControls(Composite composite) {
        this.shell = composite.getShell();
        this.shell.setText("Documentation Links");
        Group group = new Group(composite, 0);
        group.setText("");
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(1, true));
        try {
            for (Hyperlink link : links) {
                URL url = new URL(link.url);
                WebsiteLinkWidget widget = new WebsiteLinkWidget((Composite)group, 2048, link.text, url);
                widget.setSize(180, 40);
                widget.setLayoutData(new GridData(1040));
            }
            String labelText = "Documentation should open in your default web browser. It may open in its own tab or in a separate window, depending on your browser settings.";
            Label browserBehaviourExplanation = new Label((Composite)group, 64);
            browserBehaviourExplanation.setText(labelText);
            browserBehaviourExplanation.setSize(180, 120);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new Error(e.getMessage(), e);
        }
        group.pack();
        composite.pack();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    private static final class Hyperlink {
        public String text;
        public String url;

        public Hyperlink(String text, String url) {
            this.text = "<A>" + text + "</A>";
            this.url = url;
        }
    }
}

