/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.model.geocode;

public class USZipCode {
    public static final int UZIP_LENGTH = 5;
    public static final int POST_BOX_LENGTH = 4;
    public static final String UZIP_SEPARATOR = "-";
    public static final String DEFAULT_VALUE = "";
    private String uzip = "";
    private String postBox = "";

    public USZipCode(String uzip, String postBox) {
        if (uzip != null) {
            this.uzip = uzip.trim();
            if (postBox != null) {
                this.postBox = postBox.trim();
            }
        }
    }

    public String getUzip() {
        return this.uzip;
    }

    public String getPostBox() {
        return this.postBox;
    }

    public String toString() {
        if (this.postBox == DEFAULT_VALUE) {
            return this.uzip;
        }
        return String.valueOf(this.uzip) + UZIP_SEPARATOR + this.postBox;
    }

    public static USZipCode parse(String zipString) {
        if (zipString == null) {
            zipString = DEFAULT_VALUE;
        }
        String[] zipStrings = zipString.split(UZIP_SEPARATOR);
        String uzip = USZipCode.parseUzip(zipStrings);
        String postBox = USZipCode.parsePostBox(zipStrings);
        return new USZipCode(uzip, postBox);
    }

    private static String parseUzip(String[] strings) {
        String uzip = DEFAULT_VALUE;
        String uzipPrefix = DEFAULT_VALUE;
        if (strings.length > 0) {
            uzip = strings[0].trim();
            int length = uzip.length();
            if (length == 0) {
                return uzip;
            }
            if (length > 5) {
                uzip = uzip.substring(0, length - 4);
                length = uzip.length();
            }
            int remain = 5 - length;
            while (remain > 0) {
                --remain;
                uzipPrefix = String.valueOf(uzipPrefix) + "0";
            }
        }
        return String.valueOf(uzipPrefix) + uzip;
    }

    private static String parsePostBox(String[] strings) {
        int length;
        String postBox = DEFAULT_VALUE;
        if (strings.length > 1) {
            int length2 = strings[1].trim().length();
            if (length2 == 4) {
                postBox = strings[1].trim();
            }
        } else if (strings.length > 0 && (length = strings[0].trim().length()) > 5) {
            postBox = strings[0].trim().substring(length - 4);
        }
        return postBox;
    }
}

