/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.aggregatedata;

import edu.iu.sci2.preprocessing.aggregatedata.AggregateDataComputation;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class AggregateDataAlgorithm
implements Algorithm {
    private Data[] data;
    private Dictionary<String, Object> parameters;
    private LogService logger;
    private List<Integer> tableColumnNumericalParameterIDs;
    private List<Integer> tableColumnStringParameterIDs;
    public static final String AGGREGATE_ON_COLUMN = "aggregateoncolumn";

    public AggregateDataAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext context, List<Integer> inputNumericalParameterIDs, List<Integer> inputStringParameterIDs) {
        this.data = data;
        this.parameters = parameters;
        this.tableColumnNumericalParameterIDs = inputNumericalParameterIDs;
        this.tableColumnStringParameterIDs = inputStringParameterIDs;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        String aggregateOnColumnName = (String)this.parameters.get(AGGREGATE_ON_COLUMN);
        Table originalInputTable = (Table)this.data[0].getData();
        HashMap<Integer, String> columnNumberToAggregationType = new HashMap<Integer, String>();
        this.initializeNumericalAggregationParameters(columnNumberToAggregationType);
        this.initializeStringAggregationParameters(columnNumberToAggregationType);
        AggregateDataComputation aggregationComputation = new AggregateDataComputation(aggregateOnColumnName, columnNumberToAggregationType, originalInputTable, this.tableColumnNumericalParameterIDs, this.tableColumnStringParameterIDs, this.logger);
        BasicData output = new BasicData((Object)aggregationComputation.getOutputTable(), Table.class.getName());
        Dictionary metadata = output.getMetadata();
        metadata.put("Label", "Aggregation performed using unique values in '" + aggregateOnColumnName + "' column.");
        metadata.put("Parent", this.data[0]);
        metadata.put("Type", "Table");
        return new Data[]{output};
    }

    private void initializeStringAggregationParameters(Map<Integer, String> columnNumberToAggregationType) {
        for (Integer currentColumnNumber : this.tableColumnStringParameterIDs) {
            String aggregationType = (String)this.parameters.get(currentColumnNumber.toString());
            columnNumberToAggregationType.put(currentColumnNumber, aggregationType);
        }
    }

    private void initializeNumericalAggregationParameters(Map<Integer, String> columnNumberToAggregationType) {
        for (Integer currentColumnNumber : this.tableColumnNumericalParameterIDs) {
            String aggregationType = (String)this.parameters.get(currentColumnNumber.toString());
            columnNumberToAggregationType.put(currentColumnNumber, aggregationType);
        }
    }
}

