/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.aggregatedata;

import edu.iu.sci2.preprocessing.aggregatedata.AggregateDataAlgorithm;
import edu.iu.sci2.preprocessing.aggregatedata.GlobalConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.cishell.utilities.TableUtilities;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;
import prefuse.data.Schema;
import prefuse.data.Table;

public class AggregateDataAlgorithmFactory
implements AlgorithmFactory,
ParameterMutator {
    private List<Integer> inputNumericalParameterIDs;
    private List<Integer> inputStringParameterIDs;
    private static final String DEFAULT_TEXT_DELIMITER = "";
    private static final String[] NUMERICAL_AGGREGATION_TYPE_NAMES = new String[]{"None", "Sum", "Difference", "Average", "Min", "Max"};
    private static final String[] NUMERICAL_AGGREGATION_TYPE_VALUES = new String[]{"NONE", "SUM", "DIFFERENCE", "AVERAGE", "MIN", "MAX"};

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        return new AggregateDataAlgorithm(data, parameters, context, this.inputNumericalParameterIDs, this.inputStringParameterIDs);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        int parameterColumnNumber;
        String[] numericalColumnNames;
        BasicObjectClassDefinition newParameters;
        Data inData = data[0];
        Table table = (Table)inData.getData();
        try {
            newParameters = new BasicObjectClassDefinition(oldParameters.getID(), oldParameters.getName(), oldParameters.getDescription(), oldParameters.getIcon(16));
        }
        catch (IOException iOException) {
            newParameters = new BasicObjectClassDefinition(oldParameters.getID(), oldParameters.getName(), oldParameters.getDescription(), null);
        }
        AttributeDefinition[] oldAttributeDefinitions = oldParameters.getAttributeDefinitions(-1);
        List allColumnNames = TableUtilities.getAllColumnNames((Schema)table.getSchema());
        String[] currentDatasetColumns = allColumnNames.toArray(new String[allColumnNames.size()]);
        AttributeDefinition[] attributeDefinitionArray = oldAttributeDefinitions;
        int n = oldAttributeDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition oldAttributeDefinition = attributeDefinitionArray[n2];
            String oldAttributeDefinitionID = oldAttributeDefinition.getID();
            if (oldAttributeDefinitionID.equals("aggregateoncolumn")) {
                newParameters.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition(oldAttributeDefinition.getID(), oldAttributeDefinition.getName(), oldAttributeDefinition.getDescription(), oldAttributeDefinition.getType(), currentDatasetColumns, currentDatasetColumns));
            }
            ++n2;
        }
        this.inputNumericalParameterIDs = new ArrayList<Integer>();
        String[] stringArray = numericalColumnNames = TableUtilities.getValidNumberColumnNamesInTable((Table)table);
        int n3 = numericalColumnNames.length;
        n = 0;
        while (n < n3) {
            String currentColumnName = stringArray[n];
            parameterColumnNumber = table.getColumnNumber(currentColumnName);
            newParameters.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition(String.valueOf(parameterColumnNumber), currentColumnName, "Aggregate numerical column " + currentColumnName + " using following functions.", 1, NUMERICAL_AGGREGATION_TYPE_NAMES, NUMERICAL_AGGREGATION_TYPE_VALUES));
            this.inputNumericalParameterIDs.add(parameterColumnNumber);
            ++n;
        }
        this.inputStringParameterIDs = new ArrayList<Integer>();
        stringArray = currentDatasetColumns;
        n3 = currentDatasetColumns.length;
        n = 0;
        while (n < n3) {
            String currentColumnName = stringArray[n];
            if (!GlobalConstants.NUMBER_CLASS_TYPES.contains((Object)table.getColumnType(currentColumnName))) {
                parameterColumnNumber = table.getColumnNumber(currentColumnName);
                newParameters.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition(String.valueOf(parameterColumnNumber), "Delimiter for " + currentColumnName, "Aggregate string column " + currentColumnName + " using following Text Delimiter", 1, DEFAULT_TEXT_DELIMITER));
                this.inputStringParameterIDs.add(parameterColumnNumber);
            }
            ++n;
        }
        return newParameters;
    }
}

