/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.aggregatedata;

import edu.iu.sci2.preprocessing.aggregatedata.GlobalConstants;
import edu.iu.sci2.preprocessing.aggregatedata.SingleFunctionAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.DoubleAverageAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.DoubleDifferenceAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.DoubleSumAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.FloatAverageAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.FloatDifferenceAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.FloatSumAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.IntegerAverageAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.IntegerDifferenceAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.IntegerSumAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.LongAverageAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.LongDifferenceAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.LongSumAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.MaxAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.MinAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.NoneNumericalAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.NoneStringAggregator;
import edu.iu.sci2.preprocessing.aggregatedata.aggregators.StringAggregator;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cishell.utilities.NumberUtilities;
import org.cishell.utilities.TableUtilities;
import org.osgi.service.log.LogService;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.util.TableIterator;

public class AggregateDataComputation {
    private LogService logger;
    private static final String[] UNIQUE_RECORDS_COUNT_COLUMN_NAME_SUGGESTIONS = new String[]{"Count", "Aggregated_Count"};
    private String groupedOnColumnName;
    private Table originalTable;
    private Table outputTable;
    private String outputTableCountColumnName;
    private Map<Integer, String> columnNumberToAggregationType;
    private Map<Integer, SingleFunctionAggregator<?>> columnNumberToAggregationFunction;
    private List<Integer> stringAggregationColumnNumbers;
    private List<Integer> numericalAggregationColumnNumbers;

    public AggregateDataComputation(String groupedOnColumnName, Map<Integer, String> columnNumberToAggregationType, Table table, List<Integer> tableColumnNumericalParameterIDs, List<Integer> tableColumnStringParameterIDs, LogService logger) {
        this.groupedOnColumnName = groupedOnColumnName;
        this.columnNumberToAggregationType = columnNumberToAggregationType;
        this.originalTable = table;
        this.numericalAggregationColumnNumbers = tableColumnNumericalParameterIDs;
        this.stringAggregationColumnNumbers = tableColumnStringParameterIDs;
        this.logger = logger;
        this.processTable();
    }

    private void processTable() {
        HashSet<String> columnNumbersToBeRemovedFromOutput = new HashSet<String>();
        this.outputTable = this.originalTable.getSchema().instantiate();
        this.outputTableCountColumnName = TableUtilities.formNonConflictingNewColumnName((Schema)this.originalTable.getSchema(), (String[])UNIQUE_RECORDS_COUNT_COLUMN_NAME_SUGGESTIONS);
        this.outputTable.addColumn(this.outputTableCountColumnName, Integer.TYPE);
        int groupedOnColumnNumber = this.originalTable.getColumnNumber(this.groupedOnColumnName);
        int countColumnNumber = this.outputTable.getColumnNumber(this.outputTableCountColumnName);
        this.columnNumberToAggregationFunction = this.createColumnNumberToAggregationFunctionMap(groupedOnColumnNumber);
        Map<String, List<Integer>> uniqueAggregatedValueToRowNumbers = this.createAggregatedOnValueToRowNumbersMappings(groupedOnColumnNumber);
        int outputTableRowCount = 0;
        List<Integer> finalNumericalAggregationColumnNumbers = this.setupNumericalColumnsToBeProcessed(columnNumbersToBeRemovedFromOutput, groupedOnColumnNumber);
        List<Integer> finalStringAggregationColumnNumbers = this.setupStringColumnsToBeProcessed(columnNumbersToBeRemovedFromOutput, groupedOnColumnNumber);
        for (List<Integer> groupedOnValueRowNumbers : uniqueAggregatedValueToRowNumbers.values()) {
            this.outputTable.addRow();
            if (groupedOnValueRowNumbers.size() > 1) {
                Object outputTableGroupedOnValue = this.originalTable.get(groupedOnValueRowNumbers.get(0).intValue(), groupedOnColumnNumber);
                this.populateColumnFields(outputTableGroupedOnValue, outputTableRowCount, finalNumericalAggregationColumnNumbers, finalStringAggregationColumnNumbers, groupedOnValueRowNumbers);
                this.outputTable.set(outputTableRowCount, groupedOnColumnNumber, outputTableGroupedOnValue);
            } else {
                TableUtilities.copyTableRow((int)outputTableRowCount, (int)groupedOnValueRowNumbers.get(0), (Table)this.outputTable, (Table)this.originalTable);
            }
            this.outputTable.set(outputTableRowCount, countColumnNumber, (Object)groupedOnValueRowNumbers.size());
            ++outputTableRowCount;
        }
        this.logger.log(3, "Frequency of unique \"" + this.groupedOnColumnName + "\" values added to \"" + this.outputTableCountColumnName + "\" column.");
        this.removeNoneAggregationColumns(columnNumbersToBeRemovedFromOutput);
    }

    private void populateColumnFields(Object groupedOnValue, int outputTableRowCount, List<Integer> finalNumericalAggregationColumnNumbers, List<Integer> finalStringAggregationColumnNumbers, List<Integer> groupedOnValueRowNumbers) {
        this.populateNumericalColumnFields(groupedOnValue, outputTableRowCount, groupedOnValueRowNumbers, finalNumericalAggregationColumnNumbers);
        this.populateStringColumnFields(groupedOnValue, outputTableRowCount, groupedOnValueRowNumbers, finalStringAggregationColumnNumbers);
    }

    private void populateStringColumnFields(Object groupedOnValue, int outputTableRowCount, List<Integer> groupedOnValueRowNumbers, List<Integer> finalStringAggregationColumnNumbers) {
        for (Integer currentColumnNumber : finalStringAggregationColumnNumbers) {
            ArrayList<String> cellValuesToBeAggregated = new ArrayList<String>();
            int nullCount = 0;
            for (Integer currentRowNumber : groupedOnValueRowNumbers) {
                String currentCellContent = this.originalTable.getString(currentRowNumber.intValue(), currentColumnNumber.intValue());
                if (currentCellContent == null) {
                    currentCellContent = "";
                }
                if (!currentCellContent.equals("")) {
                    cellValuesToBeAggregated.add(currentCellContent);
                    continue;
                }
                ++nullCount;
            }
            SingleFunctionAggregator<?> currentColumnAggregatorFunction = this.columnNumberToAggregationFunction.get(currentColumnNumber);
            StringBuffer outputStringAggegatedValue = new StringBuffer();
            outputStringAggegatedValue.append((String)currentColumnAggregatorFunction.aggregateValue(cellValuesToBeAggregated));
            String aggregationType = this.columnNumberToAggregationType.get(currentColumnNumber);
            int currentCellContentLength = outputStringAggegatedValue.length();
            if (nullCount > 0) {
                if (nullCount == groupedOnValueRowNumbers.size()) {
                    this.logSkippedAll(groupedOnValue, this.outputTable.getColumnName(currentColumnNumber.intValue()));
                } else {
                    this.logSkipped(groupedOnValue, this.outputTable.getColumnName(currentColumnNumber.intValue()), nullCount);
                }
            }
            if (currentCellContentLength > 0) {
                outputStringAggegatedValue = outputStringAggegatedValue.delete(currentCellContentLength - aggregationType.length(), currentCellContentLength);
            }
            this.outputTable.set(outputTableRowCount, currentColumnNumber.intValue(), (Object)outputStringAggegatedValue.toString());
        }
    }

    private void populateNumericalColumnFields(Object groupedOnValue, int outputTableRowCount, List<Integer> groupedOnValueRowNumbers, List<Integer> finalNumericalAggregationColumnNumbers) {
        for (Integer currentColumnNumber : finalNumericalAggregationColumnNumbers) {
            ArrayList<Number> cellValuesToBeAggregated = new ArrayList<Number>();
            int nullCount = 0;
            int invalidCount = 0;
            for (Integer currentRowNumber : groupedOnValueRowNumbers) {
                try {
                    Object cell = this.originalTable.get(currentRowNumber.intValue(), currentColumnNumber.intValue());
                    Number number = NumberUtilities.interpretObjectAsNumber((Object)cell);
                    cellValuesToBeAggregated.add(number);
                }
                catch (NumberFormatException numberFormatException) {
                    ++invalidCount;
                }
                catch (ParseException parseException) {
                    ++invalidCount;
                }
                catch (NullPointerException nullPointerException) {
                    ++nullCount;
                }
            }
            if (nullCount > 0) {
                if (nullCount == groupedOnValueRowNumbers.size()) {
                    this.logSkippedAll(groupedOnValue, this.outputTable.getColumnName(currentColumnNumber.intValue()));
                } else {
                    this.logSkipped(groupedOnValue, this.outputTable.getColumnName(currentColumnNumber.intValue()), nullCount);
                }
            }
            if (invalidCount > 0) {
                if (invalidCount == groupedOnValueRowNumbers.size()) {
                    this.logSkippedAll(groupedOnValue, this.outputTable.getColumnName(currentColumnNumber.intValue()));
                } else {
                    this.logSkipped(groupedOnValue, this.outputTable.getColumnName(currentColumnNumber.intValue()), invalidCount);
                }
            }
            SingleFunctionAggregator<?> currentColumnAggregatorFunction = this.columnNumberToAggregationFunction.get(currentColumnNumber);
            if (cellValuesToBeAggregated.isEmpty()) continue;
            Object aggregatedValue = currentColumnAggregatorFunction.aggregateValue(cellValuesToBeAggregated);
            if (this.outputTable.getColumnType(currentColumnNumber.intValue()).isArray()) {
                Object array;
                if (aggregatedValue != null) {
                    array = Array.newInstance(this.outputTable.getColumnType(currentColumnNumber.intValue()).getComponentType(), 1);
                    Array.set(array, 0, aggregatedValue);
                    this.outputTable.set(outputTableRowCount, currentColumnNumber.intValue(), array);
                    continue;
                }
                array = Array.newInstance(this.outputTable.getColumnType(currentColumnNumber.intValue()).getComponentType(), 0);
                this.outputTable.set(outputTableRowCount, currentColumnNumber.intValue(), array);
                continue;
            }
            this.outputTable.set(outputTableRowCount, currentColumnNumber.intValue(), aggregatedValue);
        }
    }

    private Map<Integer, SingleFunctionAggregator<?>> createColumnNumberToAggregationFunctionMap(int groupedOnColumnNumber) {
        String aggregationType;
        HashMap columnNumberToAggregationFunction = new HashMap();
        for (Integer currentColumnNumber : this.numericalAggregationColumnNumbers) {
            aggregationType = this.columnNumberToAggregationType.get(currentColumnNumber);
            Class currentColumnClass = this.originalTable.getColumnType(currentColumnNumber.intValue());
            if (currentColumnNumber == groupedOnColumnNumber) {
                columnNumberToAggregationFunction.put(currentColumnNumber, new NoneNumericalAggregator());
                continue;
            }
            if ("NONE".equalsIgnoreCase(aggregationType)) {
                columnNumberToAggregationFunction.put(currentColumnNumber, new NoneNumericalAggregator());
                continue;
            }
            if ("MIN".equalsIgnoreCase(aggregationType)) {
                columnNumberToAggregationFunction.put(currentColumnNumber, new MinAggregator());
                continue;
            }
            if ("MAX".equalsIgnoreCase(aggregationType)) {
                columnNumberToAggregationFunction.put(currentColumnNumber, new MaxAggregator());
                continue;
            }
            if (GlobalConstants.INTEGER_CLASS_TYPES.contains((Object)currentColumnClass)) {
                if ("SUM".equalsIgnoreCase(aggregationType)) {
                    columnNumberToAggregationFunction.put(currentColumnNumber, new IntegerSumAggregator());
                    continue;
                }
                if ("DIFFERENCE".equalsIgnoreCase(aggregationType)) {
                    columnNumberToAggregationFunction.put(currentColumnNumber, new IntegerDifferenceAggregator());
                    continue;
                }
                if (!"AVERAGE".equalsIgnoreCase(aggregationType)) continue;
                columnNumberToAggregationFunction.put(currentColumnNumber, new IntegerAverageAggregator());
                continue;
            }
            if (GlobalConstants.FLOAT_CLASS_TYPES.contains((Object)currentColumnClass)) {
                if ("SUM".equalsIgnoreCase(aggregationType)) {
                    columnNumberToAggregationFunction.put(currentColumnNumber, new FloatSumAggregator());
                    continue;
                }
                if ("DIFFERENCE".equalsIgnoreCase(aggregationType)) {
                    columnNumberToAggregationFunction.put(currentColumnNumber, new FloatDifferenceAggregator());
                    continue;
                }
                if (!"AVERAGE".equalsIgnoreCase(aggregationType)) continue;
                columnNumberToAggregationFunction.put(currentColumnNumber, new FloatAverageAggregator());
                continue;
            }
            if (GlobalConstants.DOUBLE_CLASS_TYPES.contains((Object)currentColumnClass)) {
                if ("SUM".equalsIgnoreCase(aggregationType)) {
                    columnNumberToAggregationFunction.put(currentColumnNumber, new DoubleSumAggregator());
                    continue;
                }
                if ("DIFFERENCE".equalsIgnoreCase(aggregationType)) {
                    columnNumberToAggregationFunction.put(currentColumnNumber, new DoubleDifferenceAggregator());
                    continue;
                }
                if (!"AVERAGE".equalsIgnoreCase(aggregationType)) continue;
                columnNumberToAggregationFunction.put(currentColumnNumber, new DoubleAverageAggregator());
                continue;
            }
            if (GlobalConstants.LONG_CLASS_TYPES.contains((Object)currentColumnClass)) {
                if ("SUM".equalsIgnoreCase(aggregationType)) {
                    columnNumberToAggregationFunction.put(currentColumnNumber, new LongSumAggregator());
                    continue;
                }
                if ("DIFFERENCE".equalsIgnoreCase(aggregationType)) {
                    columnNumberToAggregationFunction.put(currentColumnNumber, new LongDifferenceAggregator());
                    continue;
                }
                if (!"AVERAGE".equalsIgnoreCase(aggregationType)) continue;
                columnNumberToAggregationFunction.put(currentColumnNumber, new LongAverageAggregator());
                continue;
            }
            this.logger.log(1, "The column's class type could not be found for " + currentColumnClass.getName() + ".");
        }
        for (Integer currentColumnNumber : this.stringAggregationColumnNumbers) {
            aggregationType = this.columnNumberToAggregationType.get(currentColumnNumber);
            if (currentColumnNumber == groupedOnColumnNumber) {
                columnNumberToAggregationFunction.put(currentColumnNumber, new NoneStringAggregator());
                continue;
            }
            if ("".equalsIgnoreCase(aggregationType)) {
                columnNumberToAggregationFunction.put(currentColumnNumber, new NoneStringAggregator());
                continue;
            }
            columnNumberToAggregationFunction.put(currentColumnNumber, new StringAggregator(aggregationType));
        }
        return columnNumberToAggregationFunction;
    }

    private void removeNoneAggregationColumns(Set<String> columnNumbersToBeRemovedFromOutput) {
        for (String currentColumnName : columnNumbersToBeRemovedFromOutput) {
            if (this.groupedOnColumnName.equalsIgnoreCase(currentColumnName)) continue;
            this.outputTable.removeColumn(currentColumnName);
            this.logger.log(3, "\"" + currentColumnName + "\" column has been deleted" + " from the output. Since No aggregation was mentioned for it.");
        }
    }

    private List<Integer> setupStringColumnsToBeProcessed(Set<String> columnNumbersToBeRemovedFromOutput, int groupedOnColumnNumber) {
        ArrayList<Integer> finalStringAggregationColumnNumbers = new ArrayList<Integer>();
        for (Integer currentColumnNumber : this.stringAggregationColumnNumbers) {
            String textDelimiter = this.columnNumberToAggregationType.get(currentColumnNumber);
            if (currentColumnNumber != groupedOnColumnNumber && !"".equalsIgnoreCase(textDelimiter)) {
                finalStringAggregationColumnNumbers.add(currentColumnNumber);
            }
            if (!"".equalsIgnoreCase(textDelimiter)) continue;
            columnNumbersToBeRemovedFromOutput.add(this.originalTable.getColumnName(currentColumnNumber.intValue()));
        }
        return finalStringAggregationColumnNumbers;
    }

    private List<Integer> setupNumericalColumnsToBeProcessed(Set<String> columnNumbersToBeRemovedFromOutput, int groupedOnColumnNumber) {
        ArrayList<Integer> finalNumericalAggregationColumnNumbers = new ArrayList<Integer>();
        for (Integer currentColumnNumber : this.numericalAggregationColumnNumbers) {
            String aggregationType = this.columnNumberToAggregationType.get(currentColumnNumber);
            if (currentColumnNumber != groupedOnColumnNumber && !"NONE".equalsIgnoreCase(aggregationType)) {
                finalNumericalAggregationColumnNumbers.add(currentColumnNumber);
            }
            if (!"NONE".equalsIgnoreCase(aggregationType)) continue;
            columnNumbersToBeRemovedFromOutput.add(this.originalTable.getColumnName(currentColumnNumber.intValue()));
        }
        return finalNumericalAggregationColumnNumbers;
    }

    private Map<String, List<Integer>> createAggregatedOnValueToRowNumbersMappings(int groupedOnColumnNumber) {
        LinkedHashMap<String, List<Integer>> uniqueGroupedValueToRowNumbers = new LinkedHashMap<String, List<Integer>>();
        HashSet<String> uniqueGroupedValues = new HashSet<String>();
        TableIterator groupedOnColumnIterator = this.originalTable.iterator();
        while (groupedOnColumnIterator.hasNext()) {
            String lowerCaseCurrentGroupedValue;
            int currentRowNumber = Integer.parseInt(groupedOnColumnIterator.next().toString());
            String currentAggregatedValue = this.originalTable.getString(currentRowNumber, groupedOnColumnNumber);
            if (currentAggregatedValue == null) {
                currentAggregatedValue = "";
            }
            if (uniqueGroupedValues.contains(lowerCaseCurrentGroupedValue = currentAggregatedValue.toLowerCase())) {
                List groupedValueMappedRowNumbers = (List)uniqueGroupedValueToRowNumbers.get(lowerCaseCurrentGroupedValue);
                groupedValueMappedRowNumbers.add(currentRowNumber);
                continue;
            }
            uniqueGroupedValues.add(lowerCaseCurrentGroupedValue);
            ArrayList<Integer> rowNumbers = new ArrayList<Integer>();
            rowNumbers.add(currentRowNumber);
            uniqueGroupedValueToRowNumbers.put(lowerCaseCurrentGroupedValue, rowNumbers);
        }
        return uniqueGroupedValueToRowNumbers;
    }

    public Table getOutputTable() {
        return this.outputTable;
    }

    private void logSkippedAll(Object groupedOnValue, String columnName) {
        String groupedOnValueString = "";
        if (groupedOnValue != null) {
            groupedOnValueString = groupedOnValue.toString();
        }
        this.logger.log(2, String.format("Aggregated by '%s': All rows of %s column were skipped due to no non-null, non-empty values.", groupedOnValueString, columnName));
    }

    private void logSkipped(Object groupedOnValue, String columnName, int totalSkipped) {
        String groupedOnValueString = "";
        if (groupedOnValue != null) {
            groupedOnValueString = groupedOnValue.toString();
        }
        String format = "Aggregated by '%s': %d row(s) of %s column were skipped due to non-existent values.";
        this.logger.log(2, String.format(format, groupedOnValueString, totalSkipped, columnName));
    }
}

