/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.extractzipcode;

import edu.iu.sci2.preprocessing.extractzipcode.ExtractZipcodeComputation;
import java.text.DecimalFormat;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class ExtractZipcodeAlgorithm
implements Algorithm {
    private static final String TRUNCATE_COLUMN = "truncate";
    private Data[] data;
    private Dictionary<String, Object> parameters;
    private LogService logger;
    public static final String PLACE_NAME_COLUMN = "addresscolumn";

    public ExtractZipcodeAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() {
        boolean truncate = Boolean.parseBoolean(this.parameters.get(TRUNCATE_COLUMN).toString());
        String addressColumnName = (String)this.parameters.get(PLACE_NAME_COLUMN);
        Table originalInputTable = (Table)this.data[0].getData();
        ExtractZipcodeComputation zipcodeExtractionComputation = new ExtractZipcodeComputation(truncate, addressColumnName, originalInputTable, this.logger);
        this.logger.log(3, String.valueOf(zipcodeExtractionComputation.getTotalZipcodesExtracted()) + " ZIP codes extracted from " + zipcodeExtractionComputation.getTotalAddressesConsidered() + " addresses.");
        BasicData output = new BasicData((Object)zipcodeExtractionComputation.getOutputTable(), Table.class.getName());
        Dictionary metadata = output.getMetadata();
        metadata.put("Label", "ZIP codes for addresses in \"" + addressColumnName + "\" is added. " + this.calculateParsingPercentage(zipcodeExtractionComputation.getTotalZipcodesExtracted(), zipcodeExtractionComputation.getTotalAddressesConsidered()) + "% ZIP codes extracted.");
        metadata.put("Parent", this.data[0]);
        metadata.put("Type", "Table");
        return new Data[]{output};
    }

    private double calculateParsingPercentage(int extractedZipcodesCount, int totalAddresses) {
        DecimalFormat roundedRatioFormat = new DecimalFormat("#.###");
        return Double.valueOf(roundedRatioFormat.format((double)extractedZipcodesCount * 100.0 / (double)totalAddresses));
    }
}

