/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.extractzipcode;

import edu.iu.sci2.preprocessing.extractzipcode.Zipcode;
import edu.iu.sci2.preprocessing.extractzipcode.ZipcodeCandidate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cishell.utilities.TableUtilities;
import org.osgi.service.log.LogService;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.util.TableIterator;

public class ExtractZipcodeComputation {
    private static final int PRIMARY_TO_EXTENSION_DISTANCE_TOLERANCE_VALUE = 2;
    private static final int EXTENSION_ZIPCODE_LENGTH = 4;
    private static final int PRIMARY_ZIPCODE_LENGTH = 5;
    private int totalAddressesConsidered = 0;
    private int totalZipcodesExtracted = 0;
    private LogService logger;
    private static final String[] ZIPCODE_COLUMN_NAME_SUGGESTIONS = new String[]{"ZIP code", "ZIP"};
    private boolean truncate;
    private String addressColumnName;
    private Table originalTable;
    private Table outputTable;
    private String outputTableZipcodeColumnName;

    public ExtractZipcodeComputation(boolean truncate, String addressColumnName, Table table, LogService logger) {
        this.truncate = truncate;
        this.addressColumnName = addressColumnName;
        this.originalTable = table;
        this.logger = logger;
        this.processTable();
    }

    private void processTable() {
        this.outputTable = this.originalTable.getSchema().instantiate();
        this.outputTableZipcodeColumnName = TableUtilities.formNonConflictingNewColumnName((Schema)this.originalTable.getSchema(), (String[])ZIPCODE_COLUMN_NAME_SUGGESTIONS);
        this.outputTable.addColumn(this.outputTableZipcodeColumnName, String.class);
        this.logger.log(3, "ZIP code added to \"" + this.outputTableZipcodeColumnName + "\" column.");
        TableIterator addressColumnIterator = this.originalTable.iterator();
        Pattern zipcodePattern = Pattern.compile("(\\d)+");
        Zipcode zipcode = null;
        String outputZipcode = "";
        while (addressColumnIterator.hasNext()) {
            int currentRowNumber = Integer.parseInt(addressColumnIterator.next().toString());
            String currentAddress = this.originalTable.getString(currentRowNumber, this.addressColumnName);
            if (currentAddress != null) {
                Matcher zipcodeMatcher = zipcodePattern.matcher(currentAddress);
                ArrayList<ZipcodeCandidate> zipcodeCandidatesInfo = new ArrayList<ZipcodeCandidate>();
                while (zipcodeMatcher.find()) {
                    zipcodeCandidatesInfo.add(new ZipcodeCandidate(currentAddress, zipcodeMatcher.group(), zipcodeMatcher.start(), zipcodeMatcher.end(), zipcodeMatcher.group().length()));
                }
                zipcode = this.selectZipcodeFromExtractedCandidates(zipcodeCandidatesInfo);
            } else {
                zipcode = new Zipcode(null, null);
            }
            if (zipcode.getPrimaryZipcode() == null) {
                outputZipcode = "";
                String message = currentAddress == null ? String.valueOf(this.addressColumnName) + " was empty in row " + currentRowNumber + "." : "No ZIP code found in '" + currentAddress + "' in row " + currentRowNumber + ".";
                message = String.valueOf(message) + " Leaving the " + this.outputTableZipcodeColumnName + " column empty for this row.";
                this.logger.log(2, message);
            } else {
                outputZipcode = this.truncate ? zipcode.getPrimaryZipcode() : (zipcode.getExtensionZipcode() != null ? String.valueOf(zipcode.getPrimaryZipcode()) + "-" + zipcode.getExtensionZipcode() : zipcode.getPrimaryZipcode());
                ++this.totalZipcodesExtracted;
            }
            this.outputTable.addRow();
            TableUtilities.copyTableRow((int)currentRowNumber, (int)currentRowNumber, (Table)this.outputTable, (Table)this.originalTable);
            this.outputTable.setString(currentRowNumber, this.outputTableZipcodeColumnName, outputZipcode);
            ++this.totalAddressesConsidered;
        }
    }

    private Zipcode selectZipcodeFromExtractedCandidates(List<ZipcodeCandidate> zipcodeCandidatesInfo) {
        int zipcodeCandidatesIndexUpperBound = zipcodeCandidatesInfo.size() - 1;
        Zipcode zipcode = new Zipcode(null, null);
        int candidateIndex = zipcodeCandidatesIndexUpperBound;
        while (candidateIndex >= 0) {
            ZipcodeCandidate currentZipcodeCandidate = zipcodeCandidatesInfo.get(candidateIndex);
            if (currentZipcodeCandidate.getLength() == 5) {
                zipcode.setPrimaryZipcode(zipcodeCandidatesInfo.get(candidateIndex).getZipCodeCandidate());
                if (candidateIndex + 1 <= zipcodeCandidatesIndexUpperBound && zipcodeCandidatesInfo.get(candidateIndex + 1).getLength() == 4 && zipcodeCandidatesInfo.get(candidateIndex + 1).getStartPosition() - zipcodeCandidatesInfo.get(candidateIndex + 1).getStartPosition() <= 2) {
                    zipcode.setExtensionZipcode(zipcodeCandidatesInfo.get(candidateIndex + 1).getZipCodeCandidate());
                }
                return zipcode;
            }
            --candidateIndex;
        }
        return zipcode;
    }

    public Table getOutputTable() {
        return this.outputTable;
    }

    public int getTotalAddressesConsidered() {
        return this.totalAddressesConsidered;
    }

    public int getTotalZipcodesExtracted() {
        return this.totalZipcodesExtracted;
    }
}

