/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.geocoder;

import edu.iu.sci2.preprocessing.geocoder.Computation;
import edu.iu.sci2.preprocessing.geocoder.DetailGeocoderComputation;
import edu.iu.sci2.preprocessing.geocoder.GeocoderAlgorithm;
import edu.iu.sci2.preprocessing.geocoder.GeocoderComputation;
import edu.iu.sci2.preprocessing.geocoder.coders.FamilyOfGeocoders;
import edu.iu.sci2.preprocessing.geocoder.coders.Geocoder;
import edu.iu.sci2.preprocessing.geocoder.coders.bing.BingFamilyOfGeocoder;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.cishell.utilities.TableUtilities;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;
import prefuse.data.Schema;
import prefuse.data.Table;

public abstract class AbstractGeocoderFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String PLACE_NAME_COLUMN = "place_name_column";
    public static final String PLACE_TYPE = "place_type";
    public static final String BING_APPLICATION_ID = "bing_application_id";
    public static final String ENABLE_DETAIL = "details";
    public static final String ADDRESS = "Address";
    public static final String COUNTRY = "Country";
    public static final String US_STATE = "US State";
    public static final String US_ZIP_CODE = "US Zip Code";
    private FamilyOfGeocoders familyGeocoder;

    protected abstract void activate(ComponentContext var1);

    protected abstract String[] getPlaceTypeOptionLabels();

    protected abstract String[] getPlaceTypeOptionValues();

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        Computation computation = GeocoderComputation.getInstance();
        if (FamilyOfGeocoders.FAMILY_TYPE.Bing.equals((Object)this.familyGeocoder.getFamilyType())) {
            ((BingFamilyOfGeocoder)BingFamilyOfGeocoder.class.cast(this.familyGeocoder)).setApplicationId((String)parameters.get(BING_APPLICATION_ID));
            if (((Boolean)Boolean.class.cast(parameters.get(ENABLE_DETAIL))).booleanValue()) {
                computation = DetailGeocoderComputation.getInstance();
            }
        }
        LogService logger = (LogService)ciShellContext.getService(LogService.class.getName());
        Table originalInputTable = (Table)data[0].getData();
        String locationColumnName = (String)parameters.get(PLACE_NAME_COLUMN);
        Geocoder geocoder = this.determineGeoCoder((String)parameters.get(PLACE_TYPE));
        return new GeocoderAlgorithm(data, logger, originalInputTable, locationColumnName, geocoder, computation);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        Data inData = data[0];
        Table table = (Table)inData.getData();
        BasicObjectClassDefinition newParameters = new BasicObjectClassDefinition(oldParameters.getID(), oldParameters.getName(), oldParameters.getDescription(), null);
        AttributeDefinition[] oldAttributeDefinitions = oldParameters.getAttributeDefinitions(-1);
        String[] probablePlaceIdentifyingColumnList = TableUtilities.getAllColumnNames((Schema)table.getSchema()).toArray(new String[0]);
        String[] placeTypeOptionLabels = this.getPlaceTypeOptionLabels();
        String[] placeTypeOptionValues = this.getPlaceTypeOptionValues();
        AttributeDefinition[] attributeDefinitionArray = oldAttributeDefinitions;
        int n = oldAttributeDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition oldAttributeDefinition = attributeDefinitionArray[n2];
            String oldAttributeDefinitionID = oldAttributeDefinition.getID();
            if (oldAttributeDefinitionID.equals(PLACE_NAME_COLUMN)) {
                newParameters.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition(oldAttributeDefinition.getID(), oldAttributeDefinition.getName(), oldAttributeDefinition.getDescription(), oldAttributeDefinition.getType(), probablePlaceIdentifyingColumnList, probablePlaceIdentifyingColumnList));
            } else if (oldAttributeDefinitionID.equals(PLACE_TYPE)) {
                newParameters.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition(oldAttributeDefinition.getID(), oldAttributeDefinition.getName(), oldAttributeDefinition.getDescription(), oldAttributeDefinition.getType(), placeTypeOptionLabels, placeTypeOptionValues));
            } else {
                newParameters.addAttributeDefinition(1, oldAttributeDefinition);
            }
            ++n2;
        }
        return newParameters;
    }

    private Geocoder determineGeoCoder(String placeType) {
        if (placeType.equalsIgnoreCase(ADDRESS)) {
            return this.familyGeocoder.getAddressCoder();
        }
        if (placeType.equalsIgnoreCase(COUNTRY)) {
            return this.familyGeocoder.getCountryCoder();
        }
        if (placeType.equalsIgnoreCase(US_STATE)) {
            return this.familyGeocoder.getStateCoder();
        }
        if (placeType.equalsIgnoreCase(US_ZIP_CODE)) {
            return this.familyGeocoder.getZipCodeCoder();
        }
        return null;
    }

    protected void setFamilyGeocoder(FamilyOfGeocoders familyGeocoder) {
        this.familyGeocoder = familyGeocoder;
    }
}

