/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.geocoder;

import edu.iu.sci2.model.geocode.GeoDetail;
import edu.iu.sci2.preprocessing.geocoder.Computation;
import edu.iu.sci2.preprocessing.geocoder.coders.DetailGeocoder;
import edu.iu.sci2.preprocessing.geocoder.coders.GeoCoderException;
import edu.iu.sci2.preprocessing.geocoder.coders.Geocoder;
import java.text.NumberFormat;
import java.util.HashMap;
import org.cishell.utilities.FrequencyMap;
import org.cishell.utilities.TableUtilities;
import org.osgi.service.log.LogService;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.util.TableIterator;

public final class DetailGeocoderComputation
implements Computation {
    private static DetailGeocoderComputation instance;
    public static final String[] LATITUDE_COLUMN_NAME_SUGGESTIONS;
    public static final String[] LONGITUDE_COLUMN_NAME_SUGGESTIONS;
    public static final String[] ZIP_CODE_COLUMN_NAME_SUGGESTIONS;
    public static final String[] COUNTY_COLUMN_NAME_SUGGESTIONS;
    public static final String[] CITY_COLUMN_NAME_SUGGESTIONS;
    public static final String[] STATE_COLUMN_NAME_SUGGESTIONS;
    public static final String[] COUNTRY_COLUMN_NAME_SUGGESTIONS;
    public static final GeoDetail DEFAULT_GEODETAIL_VALUE;

    static {
        LATITUDE_COLUMN_NAME_SUGGESTIONS = new String[]{"Latitude"};
        LONGITUDE_COLUMN_NAME_SUGGESTIONS = new String[]{"Longitude"};
        ZIP_CODE_COLUMN_NAME_SUGGESTIONS = new String[]{"ZIP code"};
        COUNTY_COLUMN_NAME_SUGGESTIONS = new String[]{"County"};
        CITY_COLUMN_NAME_SUGGESTIONS = new String[]{"City"};
        STATE_COLUMN_NAME_SUGGESTIONS = new String[]{"State"};
        COUNTRY_COLUMN_NAME_SUGGESTIONS = new String[]{"Country"};
        DEFAULT_GEODETAIL_VALUE = new GeoDetail(null, null, null, null, null, null, null);
    }

    private DetailGeocoderComputation() {
    }

    public static DetailGeocoderComputation getInstance() {
        if (instance == null) {
            instance = new DetailGeocoderComputation();
        }
        return instance;
    }

    @Override
    public Table compute(String locationColumnName, Table originalTable, LogService logger, Geocoder geocoder) {
        DetailGeocoder detailGeocoder;
        try {
            detailGeocoder = (DetailGeocoder)DetailGeocoder.class.cast(geocoder);
        }
        catch (ClassCastException e) {
            logger.log(2, String.format("The %s class does not support detail geocoding", geocoder.getClass().getName()));
            throw e;
        }
        Table outputTable = originalTable.getSchema().instantiate();
        String outputTableLatitudeColumnName = TableUtilities.formNonConflictingNewColumnName((Schema)originalTable.getSchema(), (String[])LATITUDE_COLUMN_NAME_SUGGESTIONS);
        String outputTableLongitudeColumnName = TableUtilities.formNonConflictingNewColumnName((Schema)originalTable.getSchema(), (String[])LONGITUDE_COLUMN_NAME_SUGGESTIONS);
        String outputTableZipCodeColumnName = TableUtilities.formNonConflictingNewColumnName((Schema)originalTable.getSchema(), (String[])ZIP_CODE_COLUMN_NAME_SUGGESTIONS);
        String outputTableCountyColumnName = TableUtilities.formNonConflictingNewColumnName((Schema)originalTable.getSchema(), (String[])COUNTY_COLUMN_NAME_SUGGESTIONS);
        String outputTableCityColumnName = TableUtilities.formNonConflictingNewColumnName((Schema)originalTable.getSchema(), (String[])CITY_COLUMN_NAME_SUGGESTIONS);
        String outputTableStateColumnName = TableUtilities.formNonConflictingNewColumnName((Schema)originalTable.getSchema(), (String[])STATE_COLUMN_NAME_SUGGESTIONS);
        String outputTableCountryColumnName = TableUtilities.formNonConflictingNewColumnName((Schema)originalTable.getSchema(), (String[])COUNTRY_COLUMN_NAME_SUGGESTIONS);
        outputTable.addColumn(outputTableLatitudeColumnName, Double.class);
        outputTable.addColumn(outputTableLongitudeColumnName, Double.class);
        outputTable.addColumn(outputTableZipCodeColumnName, String.class);
        outputTable.addColumn(outputTableCountyColumnName, String.class);
        outputTable.addColumn(outputTableCityColumnName, String.class);
        outputTable.addColumn(outputTableStateColumnName, String.class);
        outputTable.addColumn(outputTableCountryColumnName, String.class);
        logger.log(3, String.format("Values are added to %s, %s, %s, %s, %s ,%s & %s, respectively.", outputTableLatitudeColumnName, outputTableLongitudeColumnName, outputTableZipCodeColumnName, outputTableCountyColumnName, outputTableCityColumnName, outputTableStateColumnName, outputTableCountryColumnName));
        int locationColumnNumber = originalTable.getColumnNumber(locationColumnName);
        int latitudeColumnNumber = outputTable.getColumnNumber(outputTableLatitudeColumnName);
        int longitudeColumnNumber = outputTable.getColumnNumber(outputTableLongitudeColumnName);
        int zipCodeColumnNumber = outputTable.getColumnNumber(outputTableZipCodeColumnName);
        int streetColumnNumber = outputTable.getColumnNumber(outputTableCountyColumnName);
        int cityColumnNumber = outputTable.getColumnNumber(outputTableCityColumnName);
        int stateColumnNumber = outputTable.getColumnNumber(outputTableStateColumnName);
        int countryColumnNumber = outputTable.getColumnNumber(outputTableCountryColumnName);
        HashMap<String, GeoDetail> geocodedAddressToGeoDetail = new HashMap<String, GeoDetail>();
        FrequencyMap failedFrequency = new FrequencyMap(true);
        TableIterator locationColumnIterator = originalTable.iterator();
        while (locationColumnIterator.hasNext()) {
            int currentRowNumber = Integer.parseInt(locationColumnIterator.next().toString());
            GeoDetail geodetail = DEFAULT_GEODETAIL_VALUE;
            String currentLocation = "";
            Object currentLocationObject = originalTable.get(currentRowNumber, locationColumnNumber);
            if (currentLocationObject != null) {
                currentLocation = currentLocationObject.toString();
                String currentLocationUppercase = currentLocation.toUpperCase();
                if (geocodedAddressToGeoDetail.containsKey(currentLocationUppercase)) {
                    geodetail = (GeoDetail)geocodedAddressToGeoDetail.get(currentLocationUppercase);
                    if (geodetail == DEFAULT_GEODETAIL_VALUE) {
                        failedFrequency.add((Object)currentLocation);
                    }
                } else {
                    try {
                        geodetail = detailGeocoder.geocodingLocation(currentLocationUppercase);
                    }
                    catch (GeoCoderException geoCoderException) {
                        failedFrequency.add((Object)currentLocation);
                    }
                    geocodedAddressToGeoDetail.put(currentLocationUppercase, geodetail);
                }
            } else {
                failedFrequency.add((Object)currentLocation);
            }
            outputTable.addRow();
            TableUtilities.copyTableRow((int)currentRowNumber, (int)currentRowNumber, (Table)outputTable, (Table)originalTable);
            outputTable.set(currentRowNumber, latitudeColumnNumber, (Object)geodetail.getGeolocation().getLatitude());
            outputTable.set(currentRowNumber, longitudeColumnNumber, (Object)geodetail.getGeolocation().getLongitude());
            outputTable.set(currentRowNumber, zipCodeColumnNumber, (Object)geodetail.getZipCode().toString());
            outputTable.set(currentRowNumber, streetColumnNumber, (Object)geodetail.getCounty());
            outputTable.set(currentRowNumber, cityColumnNumber, (Object)geodetail.getCity());
            outputTable.set(currentRowNumber, stateColumnNumber, (Object)geodetail.getState());
            outputTable.set(currentRowNumber, countryColumnNumber, (Object)geodetail.getCountry());
        }
        if (!failedFrequency.isEmpty()) {
            DetailGeocoderComputation.printWarningMessage(logger, locationColumnName, (FrequencyMap<String>)failedFrequency);
        }
        int totalRow = originalTable.getRowCount();
        NumberFormat numberFormat = NumberFormat.getInstance();
        logger.log(3, String.format("Successfully geocoded %s out of %s locations to geographic coordinates", numberFormat.format(totalRow - failedFrequency.sum()), numberFormat.format(totalRow)));
        return outputTable;
    }

    private static void printWarningMessage(LogService logger, String locationColumnName, FrequencyMap<String> failedFrequency) {
        for (String location : failedFrequency.keySet()) {
            String formatString = "No geographic coordinate found for location \"%s\" (from column  \"%s\"). %d rows had this location.";
            logger.log(2, String.format(formatString, location, locationColumnName, failedFrequency.getFrequency((Object)location)));
        }
    }
}

