/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.geocoder;

import edu.iu.sci2.preprocessing.geocoder.Computation;
import edu.iu.sci2.preprocessing.geocoder.coders.Geocoder;
import java.util.Dictionary;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class GeocoderAlgorithm
implements Algorithm {
    private Data[] data;
    private LogService logger;
    private Table originalInputTable;
    private String locationColumnName;
    private Geocoder geocoder;
    private Computation computation;

    public GeocoderAlgorithm(Data[] data, LogService logger, Table originalInputTable, String locationColumnName, Geocoder geocoder, Computation computation) {
        this.data = data;
        this.logger = logger;
        this.originalInputTable = originalInputTable;
        this.locationColumnName = locationColumnName;
        this.geocoder = geocoder;
        this.computation = computation;
    }

    public Data[] execute() {
        Table outputTable = this.computation.compute(this.locationColumnName, this.originalInputTable, this.logger, this.geocoder);
        BasicData output = new BasicData((Object)outputTable, Table.class.getName());
        Dictionary metadata = output.getMetadata();
        metadata.put("Label", String.format("With Latitude & Longitude from '%s'", this.locationColumnName));
        metadata.put("Parent", this.data[0]);
        metadata.put("Type", "Table");
        return new Data[]{output};
    }
}

