/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.geocoder;

import edu.iu.sci2.model.geocode.Geolocation;
import edu.iu.sci2.preprocessing.geocoder.Computation;
import edu.iu.sci2.preprocessing.geocoder.coders.GeoCoderException;
import edu.iu.sci2.preprocessing.geocoder.coders.Geocoder;
import java.text.NumberFormat;
import java.util.HashMap;
import org.cishell.utilities.FrequencyMap;
import org.cishell.utilities.TableUtilities;
import org.osgi.service.log.LogService;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.util.TableIterator;

public final class GeocoderComputation
implements Computation {
    private static GeocoderComputation instance;
    public static final String[] LATITUDE_COLUMN_NAME_SUGGESTIONS;
    public static final String[] LONGITUDE_COLUMN_NAME_SUGGESTIONS;
    public static final Geolocation DEFAULT_NO_LOCATION_VALUE;

    static {
        LATITUDE_COLUMN_NAME_SUGGESTIONS = new String[]{"Latitude", "Lat"};
        LONGITUDE_COLUMN_NAME_SUGGESTIONS = new String[]{"Longitude", "Lon"};
        DEFAULT_NO_LOCATION_VALUE = new Geolocation(null, null);
    }

    private GeocoderComputation() {
    }

    public static GeocoderComputation getInstance() {
        if (instance == null) {
            instance = new GeocoderComputation();
        }
        return instance;
    }

    @Override
    public Table compute(String locationColumnName, Table originalTable, LogService logger, Geocoder geocoder) {
        Table outputTable = originalTable.getSchema().instantiate();
        String outputTableLatitudeColumnName = TableUtilities.formNonConflictingNewColumnName((Schema)originalTable.getSchema(), (String[])LATITUDE_COLUMN_NAME_SUGGESTIONS);
        String outputTableLongitudeColumnName = TableUtilities.formNonConflictingNewColumnName((Schema)originalTable.getSchema(), (String[])LONGITUDE_COLUMN_NAME_SUGGESTIONS);
        outputTable.addColumn(outputTableLatitudeColumnName, Double.class);
        outputTable.addColumn(outputTableLongitudeColumnName, Double.class);
        logger.log(3, String.format("Latitude & Longitude values added to %s & %s, respectively.", outputTableLatitudeColumnName, outputTableLongitudeColumnName));
        int locationColumnNumber = originalTable.getColumnNumber(locationColumnName);
        int latitudeColumnNumber = outputTable.getColumnNumber(outputTableLatitudeColumnName);
        int longitudeColumnNumber = outputTable.getColumnNumber(outputTableLongitudeColumnName);
        HashMap<String, Geolocation> geocodedAddressToGeoLocation = new HashMap<String, Geolocation>();
        FrequencyMap failedFrequency = new FrequencyMap(true);
        TableIterator locationColumnIterator = originalTable.iterator();
        while (locationColumnIterator.hasNext()) {
            int currentRowNumber = Integer.parseInt(locationColumnIterator.next().toString());
            Geolocation geolocation = DEFAULT_NO_LOCATION_VALUE;
            String currentLocation = "";
            Object currentLocationObject = originalTable.get(currentRowNumber, locationColumnNumber);
            if (currentLocationObject != null) {
                currentLocation = currentLocationObject.toString();
                String currentLocationUppercase = currentLocation.toUpperCase();
                if (geocodedAddressToGeoLocation.containsKey(currentLocationUppercase)) {
                    geolocation = (Geolocation)geocodedAddressToGeoLocation.get(currentLocationUppercase);
                    if (geolocation == DEFAULT_NO_LOCATION_VALUE) {
                        failedFrequency.add((Object)currentLocation);
                    }
                } else {
                    try {
                        geolocation = geocoder.geocodingFullForm(currentLocationUppercase);
                    }
                    catch (GeoCoderException geoCoderException) {
                        try {
                            geolocation = geocoder.geocodingAbbreviation(currentLocationUppercase);
                        }
                        catch (GeoCoderException geoCoderException2) {
                            failedFrequency.add((Object)currentLocation);
                        }
                    }
                    geocodedAddressToGeoLocation.put(currentLocationUppercase, geolocation);
                }
            } else {
                failedFrequency.add((Object)currentLocation);
            }
            outputTable.addRow();
            TableUtilities.copyTableRow((int)currentRowNumber, (int)currentRowNumber, (Table)outputTable, (Table)originalTable);
            outputTable.set(currentRowNumber, latitudeColumnNumber, (Object)geolocation.getLatitude());
            outputTable.set(currentRowNumber, longitudeColumnNumber, (Object)geolocation.getLongitude());
        }
        if (!failedFrequency.isEmpty()) {
            GeocoderComputation.printWarningMessage(logger, locationColumnName, (FrequencyMap<String>)failedFrequency);
        }
        int totalRow = originalTable.getRowCount();
        NumberFormat numberFormat = NumberFormat.getInstance();
        logger.log(3, String.format("Successfully geocoded %s out of %s locations to geographic coordinates", numberFormat.format(totalRow - failedFrequency.sum()), numberFormat.format(totalRow)));
        return outputTable;
    }

    private static void printWarningMessage(LogService logger, String locationColumnName, FrequencyMap<String> failedFrequency) {
        for (String location : failedFrequency.keySet()) {
            String formatString = "No geographic coordinate found for location \"%s\" (from column  \"%s\"). %d rows had this location.";
            logger.log(2, String.format(formatString, location, locationColumnName, failedFrequency.getFrequency((Object)location)));
        }
    }
}

