/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.geocoder.coders.bing;

import edu.iu.sci2.model.geocode.GeoDetail;
import edu.iu.sci2.model.geocode.Geolocation;
import edu.iu.sci2.model.geocode.USZipCode;
import edu.iu.sci2.preprocessing.geocoder.coders.DetailGeocoder;
import edu.iu.sci2.preprocessing.geocoder.coders.GeoCoderException;
import edu.iu.sci2.preprocessing.geocoder.coders.Geocoder;
import edu.iu.sci2.preprocessing.geocoder.coders.bing.placefinder.beans.Response;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.cishell.utilities.network.DownloadHandler;

public abstract class AbstractBingCoder
implements Geocoder,
DetailGeocoder {
    private final String applicationId;

    public AbstractBingCoder(String applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public abstract Geocoder.CODER_TYPE getLocationType();

    public abstract Response requestBingService(String var1, String var2) throws IOException, JAXBException, DownloadHandler.InvalidUrlException, DownloadHandler.NetworkConnectionException;

    @Override
    public Geolocation geocodingFullForm(String fullForm) throws GeoCoderException {
        try {
            Response resp = this.requestBingService(fullForm, this.applicationId);
            return this.extractGeoLocation(resp);
        }
        catch (IOException e) {
            throw new GeoCoderException("Bing service error", e);
        }
        catch (JAXBException e) {
            throw new GeoCoderException("Bing service error", (Exception)((Object)e));
        }
        catch (DownloadHandler.InvalidUrlException e) {
            throw new GeoCoderException("Bing service error", (Exception)((Object)e));
        }
        catch (DownloadHandler.NetworkConnectionException e) {
            throw new GeoCoderException("Bing service error", (Exception)((Object)e));
        }
    }

    @Override
    public Geolocation geocodingAbbreviation(String abbreviation) throws GeoCoderException {
        return this.geocodingFullForm(abbreviation);
    }

    @Override
    public GeoDetail geocodingLocation(String locationString) throws GeoCoderException {
        try {
            return this.extractGeoDetail(this.requestBingService(locationString, this.applicationId));
        }
        catch (IOException e) {
            throw new GeoCoderException("Bing service error", e);
        }
        catch (JAXBException e) {
            throw new GeoCoderException("Bing service error", (Exception)((Object)e));
        }
        catch (DownloadHandler.InvalidUrlException e) {
            throw new GeoCoderException("Bing service error", (Exception)((Object)e));
        }
        catch (DownloadHandler.NetworkConnectionException e) {
            throw new GeoCoderException("Bing service error", (Exception)((Object)e));
        }
    }

    private GeoDetail extractGeoDetail(Response response) throws GeoCoderException {
        Geolocation geolocation = this.extractGeoLocation(response);
        if (geolocation != null) {
            List<Response.ResourceSets.ResourceSet.Resources.Location> locations = response.getResourceSets().getResourceSet().getResources().getLocation();
            Response.ResourceSets.ResourceSet.Resources.Location location = locations.get(0);
            Response.ResourceSets.ResourceSet.Resources.Location.Address address = location.getAddress();
            return new GeoDetail(geolocation, USZipCode.parse((String)address.getPostalCode()), address.getAddressLine(), address.getLocality(), address.getAdminDistrict(), address.getCountryRegion(), address.getAdminDistrict2());
        }
        throw new GeoCoderException("No result found");
    }

    private Geolocation extractGeoLocation(Response response) throws GeoCoderException {
        List<Response.ResourceSets.ResourceSet.Resources.Location> locations = null;
        try {
            locations = response.getResourceSets().getResourceSet().getResources().getLocation();
        }
        catch (NullPointerException nullPointerException) {
            throw new GeoCoderException("No result found");
        }
        if (locations.size() > 0) {
            Response.ResourceSets.ResourceSet.Resources.Location location = locations.get(0);
            return new Geolocation(new Double(location.getPoint().getLatitude()), new Double(location.getPoint().getLongitude()));
        }
        throw new GeoCoderException("No result found");
    }
}

