/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.geocoder.coders.bing.placefinder;

import edu.iu.sci2.preprocessing.geocoder.coders.bing.placefinder.UnmarshallerJAXB;
import edu.iu.sci2.preprocessing.geocoder.coders.bing.placefinder.beans.Response;
import java.io.IOException;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.cishell.utilities.network.DownloadHandler;

public final class PlaceFinderClient {
    public static final int BUFFER_SIZE = 4096;
    public static final int RETRIES = 3;
    public static final String GET_METHOD = "GET";
    public static final String SERVICE_EPR = "http://dev.virtualearth.net/REST/v1/Locations?";
    public static final String LOCATION_PARAM = "q";
    public static final String APPID_PARAM = "key";
    public static final String OUTPUT_PARAM = "o";
    public static final String OUTPUT_TYPE = "xml";
    public static final String VALUE_SEPARATOR = "=";
    public static final String PARAM_SEPARATOR = "&";
    public static final String SPACE_CHAR = " ";
    public static final String SPACE_REPLACEMENT = "%20";
    public static final String SCHEMA_FILENAME = "placeFinder.xsd";

    private PlaceFinderClient() {
    }

    public static Response requestAddress(String address, String applicationId) throws IOException, JAXBException, DownloadHandler.InvalidUrlException, DownloadHandler.NetworkConnectionException {
        HashMap<String, String> paramToValue = new HashMap<String, String>();
        paramToValue.put(LOCATION_PARAM, address);
        paramToValue.put(APPID_PARAM, applicationId);
        paramToValue.put(OUTPUT_PARAM, OUTPUT_TYPE);
        return PlaceFinderClient.request(paramToValue);
    }

    public static Response requestCountry(String country, String applicationId) throws IOException, JAXBException, DownloadHandler.InvalidUrlException, DownloadHandler.NetworkConnectionException {
        HashMap<String, String> paramToValue = new HashMap<String, String>();
        paramToValue.put(LOCATION_PARAM, "&countryRegion=" + country);
        paramToValue.put(OUTPUT_PARAM, OUTPUT_TYPE);
        paramToValue.put(APPID_PARAM, applicationId);
        return PlaceFinderClient.request(paramToValue);
    }

    public static Response requestState(String state, String country, String applicationId) throws IOException, JAXBException, DownloadHandler.InvalidUrlException, DownloadHandler.NetworkConnectionException {
        HashMap<String, String> paramToValue = new HashMap<String, String>();
        paramToValue.put(LOCATION_PARAM, "&adminDistrict=" + state);
        paramToValue.put(OUTPUT_PARAM, OUTPUT_TYPE);
        paramToValue.put(APPID_PARAM, applicationId);
        return PlaceFinderClient.request(paramToValue);
    }

    public static Response requestZipCode(String zipCode, String country, String applicationId) throws IOException, JAXBException, DownloadHandler.InvalidUrlException, DownloadHandler.NetworkConnectionException {
        HashMap<String, String> paramToValue = new HashMap<String, String>();
        paramToValue.put(LOCATION_PARAM, "&postalCode=" + zipCode + "&countryRegion=" + country);
        paramToValue.put(OUTPUT_PARAM, OUTPUT_TYPE);
        paramToValue.put(APPID_PARAM, applicationId);
        return PlaceFinderClient.request(paramToValue);
    }

    private static Response request(Map<String, String> paramToValue) throws IOException, JAXBException, DownloadHandler.InvalidUrlException, DownloadHandler.NetworkConnectionException {
        URL url = PlaceFinderClient.createURL(paramToValue);
        String responseString = PlaceFinderClient.query(GET_METHOD, url);
        return PlaceFinderClient.generateResponse(responseString);
    }

    private static Response generateResponse(String inputString) throws JAXBException {
        URL schemaURL = PlaceFinderClient.class.getResource(SCHEMA_FILENAME);
        UnmarshallerJAXB unmarshallerJAXB = UnmarshallerJAXB.newInstance(schemaURL);
        if (unmarshallerJAXB != null) {
            int responsePosition = inputString.indexOf("Response");
            String ResponseTag = inputString.substring(responsePosition + "Response".length(), responsePosition + inputString.substring(responsePosition).indexOf(62));
            inputString = inputString.substring(inputString.indexOf(60));
            inputString = inputString.replace(ResponseTag, "");
            StringReader reader = new StringReader(inputString);
            Response response = unmarshallerJAXB.unmarshal(reader);
            return response;
        }
        Response response = new Response();
        return response;
    }

    private static String query(String method, URL url) throws IOException, DownloadHandler.InvalidUrlException, DownloadHandler.NetworkConnectionException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        return DownloadHandler.getResponse((HttpURLConnection)connection);
    }

    private static URL createURL(Map<String, String> paramToValue) throws MalformedURLException {
        StringBuilder builder = new StringBuilder();
        builder.append(SERVICE_EPR);
        Iterator<String> paramIterator = paramToValue.keySet().iterator();
        String param = paramIterator.next();
        builder.append(param);
        builder.append(VALUE_SEPARATOR);
        builder.append(paramToValue.get(param).replaceAll(SPACE_CHAR, SPACE_REPLACEMENT));
        while (paramIterator.hasNext()) {
            param = paramIterator.next();
            builder.append(PARAM_SEPARATOR);
            builder.append(param);
            builder.append(VALUE_SEPARATOR);
            if (paramToValue.get(param) == null) continue;
            builder.append(paramToValue.get(param).replaceAll(SPACE_CHAR, SPACE_REPLACEMENT));
        }
        return new URL(builder.toString());
    }
}

