/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.geocoder.coders.generic;

import edu.iu.sci2.preprocessing.geocoder.coders.FamilyOfGeocoders;
import edu.iu.sci2.preprocessing.geocoder.coders.Geocoder;
import edu.iu.sci2.preprocessing.geocoder.coders.generic.CountryCoder;
import edu.iu.sci2.preprocessing.geocoder.coders.generic.StateCoder;
import edu.iu.sci2.preprocessing.geocoder.coders.generic.ZipCodeCoder;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;

public class GenericFamilyOfGeocoder
implements FamilyOfGeocoders {
    private static final String COUNTRY_GEO_CODE_FILE_PATH = "countries_geo_code.txt";
    private static final String US_STATE_GEO_CODE_FILE_PATH = "us_states_geo_code.txt";
    private static final String US_ZIP_CODE_GEO_CODE_FILE_PATH = "us_zipcode_geo_code.csv";
    private Map<Geocoder.CODER_TYPE, URL> coderTypeToUrl = new HashMap<Geocoder.CODER_TYPE, URL>();

    public GenericFamilyOfGeocoder(BundleContext bundleContext) {
        this.coderTypeToUrl.put(Geocoder.CODER_TYPE.US_STATE, bundleContext.getBundle().getResource(US_STATE_GEO_CODE_FILE_PATH));
        this.coderTypeToUrl.put(Geocoder.CODER_TYPE.COUNTRY, bundleContext.getBundle().getResource(COUNTRY_GEO_CODE_FILE_PATH));
        this.coderTypeToUrl.put(Geocoder.CODER_TYPE.US_ZIP_CODE, bundleContext.getBundle().getResource(US_ZIP_CODE_GEO_CODE_FILE_PATH));
    }

    @Override
    public FamilyOfGeocoders.FAMILY_TYPE getFamilyType() {
        return FamilyOfGeocoders.FAMILY_TYPE.Generic;
    }

    @Override
    public Geocoder getCountryCoder() {
        return new CountryCoder(this.coderTypeToUrl.get((Object)Geocoder.CODER_TYPE.COUNTRY));
    }

    @Override
    public Geocoder getStateCoder() {
        return new StateCoder(this.coderTypeToUrl.get((Object)Geocoder.CODER_TYPE.US_STATE));
    }

    @Override
    public Geocoder getZipCodeCoder() {
        return new ZipCodeCoder(this.coderTypeToUrl.get((Object)Geocoder.CODER_TYPE.US_ZIP_CODE));
    }

    @Override
    public Geocoder getAddressCoder() {
        return null;
    }

    @Override
    public Set<Geocoder.CODER_TYPE> getSupportedCoders() {
        return Collections.unmodifiableSet(this.coderTypeToUrl.keySet());
    }
}

