/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.geocoder.coders.generic;

import edu.iu.sci2.model.geocode.Geolocation;
import edu.iu.sci2.preprocessing.geocoder.coders.GeoCoderException;
import edu.iu.sci2.preprocessing.geocoder.coders.Geocoder;
import edu.iu.sci2.preprocessing.geocoder.coders.NoCacheFoundException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class StateCoder
implements Geocoder {
    public static final int CACHE_ROW_ABBREVIATION_INDEX = 1;
    public static final int CACHE_ROW_FULLFORM_INDEX = 0;
    public static final int CACHE_ROW_LONGITUDE_INDEX = 3;
    public static final int CACHE_ROW_LATITUDE_INDEX = 2;
    private Map<String, Geolocation> stateFullFormToLocation = null;
    private URL stateFile;
    private Map<String, Geolocation> stateAbbreviationToLocation = null;

    public StateCoder(URL stateFile) {
        this.stateFile = stateFile;
    }

    @Override
    public Geocoder.CODER_TYPE getLocationType() {
        return Geocoder.CODER_TYPE.US_STATE;
    }

    private void initializeStateLocationMappings(URL stateLocationFilePath) throws GeoCoderException {
        this.stateFullFormToLocation = new HashMap<String, Geolocation>();
        this.stateAbbreviationToLocation = new HashMap<String, Geolocation>();
        InputStream inStream = null;
        BufferedReader input = null;
        try {
            try {
                String line;
                URLConnection connection = stateLocationFilePath.openConnection();
                connection.setDoInput(true);
                inStream = connection.getInputStream();
                input = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                while ((line = input.readLine()) != null) {
                    String[] lineTokens = line.split(";");
                    double latitude = Double.parseDouble(lineTokens[2]);
                    double longitude = Double.parseDouble(lineTokens[3]);
                    Geolocation location = new Geolocation(Double.valueOf(latitude), Double.valueOf(longitude));
                    this.stateFullFormToLocation.put(lineTokens[0], location);
                    this.stateAbbreviationToLocation.put(lineTokens[1], location);
                }
            }
            catch (IOException iOException) {
                String exceptionMessage = String.format("Unable to access state database URL %s", stateLocationFilePath.toString());
                throw new NoCacheFoundException(exceptionMessage);
            }
        }
        catch (Throwable throwable) {
            try {
                if (input != null) {
                    input.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                String exceptionMessage = String.format("Unable to close file for state database %s", stateLocationFilePath.toString());
                throw new GeoCoderException(exceptionMessage, e);
            }
            throw throwable;
        }
        try {
            if (input != null) {
                input.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        catch (IOException e) {
            String exceptionMessage = String.format("Unable to close file for state database %s", stateLocationFilePath.toString());
            throw new GeoCoderException(exceptionMessage, e);
        }
    }

    @Override
    public Geolocation geocodingFullForm(String fullForm) throws GeoCoderException {
        if (this.stateFullFormToLocation == null) {
            this.initializeStateLocationMappings(this.stateFile);
        }
        return this.getGeolocationFromMap(this.stateFullFormToLocation, fullForm);
    }

    @Override
    public Geolocation geocodingAbbreviation(String abbreviation) throws GeoCoderException {
        if (this.stateAbbreviationToLocation == null) {
            this.initializeStateLocationMappings(this.stateFile);
        }
        return this.getGeolocationFromMap(this.stateAbbreviationToLocation, abbreviation);
    }

    private Geolocation getGeolocationFromMap(Map<String, Geolocation> maps, String state) throws GeoCoderException {
        Geolocation geolocation = maps.get(state);
        if (geolocation == null) {
            throw new GeoCoderException("Result not found");
        }
        return geolocation;
    }
}

