/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.geocoder.coders.generic;

import au.com.bytecode.opencsv.CSVReader;
import edu.iu.sci2.model.geocode.Geolocation;
import edu.iu.sci2.model.geocode.USZipCode;
import edu.iu.sci2.preprocessing.geocoder.coders.GeoCoderException;
import edu.iu.sci2.preprocessing.geocoder.coders.Geocoder;
import edu.iu.sci2.preprocessing.geocoder.coders.NoCacheFoundException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ZipCodeCoder
implements Geocoder {
    public static final String LOCATION_AS_ZIPCODE_IDENTIFIER = "ZIP CODE";
    public static final Map<String, String> EMPTY_FORMS_TO_LOCATIONS = Collections.unmodifiableMap(new HashMap());
    private Map<String, Geolocation> zipCodeToLocation;
    private URL zipCodeFile;
    private static final int ZIPCODE_INDEX = 0;
    private static final int LATITUDE_INDEX = 1;
    private static final int LONGITUDE_INDEX = 2;

    public ZipCodeCoder(URL zipCodeFile) {
        this.zipCodeFile = zipCodeFile;
    }

    @Override
    public Geocoder.CODER_TYPE getLocationType() {
        return Geocoder.CODER_TYPE.US_ZIP_CODE;
    }

    private void initializeZipCodeLocationMappings(URL zipCodeFile) throws GeoCoderException {
        InputStream inStream = null;
        BufferedReader input = null;
        try {
            try {
                URLConnection connection = zipCodeFile.openConnection();
                connection.setDoInput(true);
                inStream = connection.getInputStream();
                input = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                CSVReader zipCsvReader = new CSVReader((Reader)input);
                this.zipCodeToLocation = ZipCodeCoder.createMapFromZipcodeToLocation(zipCsvReader);
            }
            catch (IOException iOException) {
                String exceptionMessage = String.format("Unable to access zipcode database URL %s", zipCodeFile.toString());
                throw new NoCacheFoundException(exceptionMessage);
            }
        }
        catch (Throwable throwable) {
            try {
                if (input != null) {
                    input.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                String exceptionMessage = String.format("Unable to close file for zipcode database %s", zipCodeFile.toString());
                throw new GeoCoderException(exceptionMessage, e);
            }
            throw throwable;
        }
        try {
            if (input != null) {
                input.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        catch (IOException e) {
            String exceptionMessage = String.format("Unable to close file for zipcode database %s", zipCodeFile.toString());
            throw new GeoCoderException(exceptionMessage, e);
        }
    }

    private static Map<String, Geolocation> createMapFromZipcodeToLocation(CSVReader zipCsvReader) throws GeoCoderException {
        try {
            String[] zipAndLocationLine;
            zipCsvReader.readNext();
            HashMap<String, Geolocation> zipCodeToLocation = new HashMap<String, Geolocation>();
            while ((zipAndLocationLine = zipCsvReader.readNext()) != null) {
                String zip = zipAndLocationLine[0];
                String latitudeString = zipAndLocationLine[1];
                String longitudeString = zipAndLocationLine[2];
                double latitude = Double.valueOf(latitudeString);
                double longitude = Double.valueOf(longitudeString);
                Geolocation location = new Geolocation(Double.valueOf(latitude), Double.valueOf(longitude));
                zipCodeToLocation.put(USZipCode.parse((String)zip).getUzip(), location);
            }
            return zipCodeToLocation;
        }
        catch (IOException e) {
            throw new GeoCoderException("IO error occurred while reading zipcodes from zipcode database file", e);
        }
    }

    @Override
    public Geolocation geocodingFullForm(String fullForm) throws GeoCoderException {
        Geolocation geolocation;
        if (this.zipCodeToLocation == null) {
            this.initializeZipCodeLocationMappings(this.zipCodeFile);
        }
        if ((geolocation = this.zipCodeToLocation.get(USZipCode.parse((String)fullForm).getUzip())) == null) {
            throw new GeoCoderException("Result not found");
        }
        return geolocation;
    }

    @Override
    public Geolocation geocodingAbbreviation(String abbreviation) throws GeoCoderException {
        throw new GeoCoderException("No result is found");
    }
}

