/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.mergenetworks;

import edu.iu.nwb.converter.nwb.common.NWBAttribute;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.sci2.preprocessing.mergenetworks.valueobjects.Edge;
import edu.iu.sci2.preprocessing.mergenetworks.valueobjects.Node;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.service.log.LogService;

public class MergeNetworkAssetsComputation
implements NWBFileParserHandler {
    private Map<Object, Node> nodeIDToNode;
    private Map<String, Edge> edgeIDToEdge;
    private String uniqueNodeIdentifierColumnName;
    private LogService logger;
    private Map<String, NWBAttribute> oldNodeAttributeNameToNewAttribute;
    private Map<String, NWBAttribute> oldEdgeAttributeNameToNewAttribute;
    private String thisNetworkName;
    private String otherNetworkName;
    private String EDGE_SEPARATOR = "$";
    public static final String YES = "T";
    public static final String NO = "F";

    public MergeNetworkAssetsComputation(String uniqueNodeIdentifierColumnName, Map<String, NWBAttribute> oldNodeAttributeNameToNewAttribute, Map<String, NWBAttribute> oldEdgeAttributeNameToNewAttribute, Map<Object, Node> nodeIDToNodeObject, Map<String, Edge> edgeIdentifierToEdgeObject, String thisNetworkName, String otherNetworkName, LogService logger) {
        this.uniqueNodeIdentifierColumnName = uniqueNodeIdentifierColumnName;
        this.oldNodeAttributeNameToNewAttribute = oldNodeAttributeNameToNewAttribute;
        this.oldEdgeAttributeNameToNewAttribute = oldEdgeAttributeNameToNewAttribute;
        this.nodeIDToNode = nodeIDToNodeObject;
        this.edgeIDToEdge = edgeIdentifierToEdgeObject;
        this.thisNetworkName = thisNetworkName;
        this.otherNetworkName = otherNetworkName;
        this.logger = logger;
    }

    private void createEdgeTupleElements(int node1, int node2, Map attributes, boolean isUnDirectedEdge) {
        Edge edge;
        String edgeIdentifier = this.getEdgeID(node1, node2);
        if (!this.edgeIDToEdge.containsKey(edgeIdentifier)) {
            edge = new Edge(node1, node2);
            this.edgeIDToEdge.put(edgeIdentifier, edge);
        } else {
            edge = this.edgeIDToEdge.get(edgeIdentifier);
        }
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry nameToTypeObject;
            Map.Entry nameToValue = nameToTypeObject = iterator.next();
            String newAttributeName = this.oldEdgeAttributeNameToNewAttribute.get(nameToValue.getKey()).getAttrName();
            edge.addAttribute(newAttributeName, nameToValue.getValue());
        }
        String edgeIsInThisNetwork_AttributeName = "present_in_" + this.thisNetworkName;
        Object edgeIsInThisNetwork = edge.getAttribute(edgeIsInThisNetwork_AttributeName);
        if (edgeIsInThisNetwork == null) {
            edge.addAttribute(edgeIsInThisNetwork_AttributeName, YES);
        } else if (!YES.equals(edgeIsInThisNetwork) && NO.equals(edgeIsInThisNetwork)) {
            edge.addAttribute(edgeIsInThisNetwork_AttributeName, YES);
        }
        String edgeIsInOtherNetwork_AttributeName = "present_in_" + this.otherNetworkName;
        Object edgeIsInOtherNetwork = edge.getAttribute(edgeIsInOtherNetwork_AttributeName);
        if (edgeIsInOtherNetwork == null) {
            edge.addAttribute(edgeIsInOtherNetwork_AttributeName, NO);
        }
        YES.equals(edgeIsInOtherNetwork);
        NO.equals(edgeIsInOtherNetwork);
    }

    private String getEdgeID(int node1, int node2) {
        if (node1 > node2) {
            return String.format("%s%s%s", node2, this.EDGE_SEPARATOR, node1);
        }
        return String.format("%s%s%s", node1, this.EDGE_SEPARATOR, node2);
    }

    public void addNode(int id, String label, Map attributes) {
        Node node;
        Object uniqueIdentifierValue = this.getUniqueIdentifierValue(id, label, attributes);
        if (!this.nodeIDToNode.containsKey(uniqueIdentifierValue)) {
            node = new Node(id, label);
            this.nodeIDToNode.put(uniqueIdentifierValue, node);
        } else {
            node = this.nodeIDToNode.get(uniqueIdentifierValue);
        }
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry nameToTypeObject;
            Map.Entry nameToValue = nameToTypeObject = iterator.next();
            String newAttributeName = this.oldNodeAttributeNameToNewAttribute.get(nameToValue.getKey()).getAttrName();
            node.addAttribute(newAttributeName, nameToValue.getValue());
        }
    }

    private Object getUniqueIdentifierValue(int id, String label, Map attributes) {
        if (this.uniqueNodeIdentifierColumnName.equalsIgnoreCase("id")) {
            return id;
        }
        if (this.uniqueNodeIdentifierColumnName.equalsIgnoreCase("label")) {
            return label;
        }
        return attributes.get(this.uniqueNodeIdentifierColumnName);
    }

    public void addUndirectedEdge(int node1, int node2, Map attributes) {
        this.createEdgeTupleElements(node1, node2, attributes, true);
    }

    public void finishedParsing() {
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map attributes) {
    }

    public boolean haltParsingNow() {
        return false;
    }

    public void addComment(String comment) {
    }

    public void setDirectedEdgeCount(int numberOfEdges) {
    }

    public void setDirectedEdgeSchema(LinkedHashMap schema) {
    }

    public void setNodeCount(int numberOfNodes) {
    }

    public void setNodeSchema(LinkedHashMap schema) {
    }

    public void setUndirectedEdgeCount(int numberOfEdges) {
    }

    public void setUndirectedEdgeSchema(LinkedHashMap schema) {
    }
}

