/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.mergenetworks;

import edu.iu.nwb.converter.nwb.common.NWBAttribute;
import edu.iu.nwb.converter.nwb.common.ValidateNWBFile;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import edu.iu.sci2.preprocessing.mergenetworks.MergeNetworkAssetsComputation;
import edu.iu.sci2.preprocessing.mergenetworks.utils.Constants;
import edu.iu.sci2.preprocessing.mergenetworks.utils.MergedNetworkSchemas;
import edu.iu.sci2.preprocessing.mergenetworks.utils.MergedNetworkToNWBFileWriter;
import edu.iu.sci2.preprocessing.mergenetworks.valueobjects.Edge;
import edu.iu.sci2.preprocessing.mergenetworks.valueobjects.MergeNetworksHelper;
import edu.iu.sci2.preprocessing.mergenetworks.valueobjects.NetworkMetadata;
import edu.iu.sci2.preprocessing.mergenetworks.valueobjects.Node;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;

public class MergeNetworks
implements Algorithm {
    private static final int MIN_EDGE_ATTRIBUTES = 2;
    private static final int MIN_NODE_ATTRIBUTES = 1;
    private Data[] data;
    private Dictionary parameters;
    private LogService logger;
    public static final String IS_PRESENT_IN_NETWORK_PREFIX = "present_in_";

    public MergeNetworks(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        File firstInputNetwork = null;
        File secondInputNetwork = null;
        MergeNetworksHelper mergeNetworksHelper = null;
        String firstNetworkName = (String)this.parameters.get("firstnetworkprefix");
        String secondNetworkName = (String)this.parameters.get("secondnetworkprefix");
        String nodeIdentifierColumnName = (String)this.parameters.get("identifier");
        try {
            firstInputNetwork = (File)this.data[0].getData();
            NetworkMetadata firstNetworkMetadata = this.getNetworkMetadata(firstInputNetwork);
            secondInputNetwork = (File)this.data[1].getData();
            NetworkMetadata secondNetworkMetadata = this.getNetworkMetadata(secondInputNetwork);
            mergeNetworksHelper = this.resolveNodeAndEdgeSchema(nodeIdentifierColumnName, firstNetworkName, secondNetworkName, firstNetworkMetadata, secondNetworkMetadata);
        }
        catch (AlgorithmExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            HashMap<Object, Node> nodeIDToNodeObject = new HashMap<Object, Node>();
            HashMap<String, Edge> edgeIDToEdgeObject = new HashMap<String, Edge>();
            this.mergeNetworkNodesAndEdges(firstInputNetwork, secondInputNetwork, nodeIdentifierColumnName, mergeNetworksHelper, nodeIDToNodeObject, edgeIDToEdgeObject, firstNetworkName, secondNetworkName);
            File nwbFile = MergedNetworkToNWBFileWriter.writeMergedNetworkToNWBFile(mergeNetworksHelper, nodeIDToNodeObject, edgeIDToEdgeObject);
            Data[] outData = this.wrapOutData(nwbFile);
            return outData;
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private MergeNetworksHelper resolveNodeAndEdgeSchema(String nodeIdentifierColumnName, String firstInputAttributeCollisionResolvingName, String secondInputAttributeCollisionResolvingName, NetworkMetadata firstNetworkMetadata, NetworkMetadata secondNetworkMetadata) throws AlgorithmExecutionException {
        MergeNetworksHelper mergeNetworksHelper = new MergeNetworksHelper();
        HashSet<String> nodeAttributeNamesToBeIgnored = new HashSet<String>();
        nodeAttributeNamesToBeIgnored.add(nodeIdentifierColumnName);
        nodeAttributeNamesToBeIgnored.addAll(Constants.NWB_FORMAT_MANDATED_NODE_ATTRIBUTES);
        HashSet<String> edgeAttributeNamesToBeIgnored = new HashSet<String>();
        edgeAttributeNamesToBeIgnored.addAll(Constants.NWB_FORMAT_MANDATED_EDGE_ATTRIBUTES);
        MergedNetworkSchemas mergedNetworkSchemas = new MergedNetworkSchemas(nodeAttributeNamesToBeIgnored, edgeAttributeNamesToBeIgnored, firstInputAttributeCollisionResolvingName, secondInputAttributeCollisionResolvingName);
        mergeNetworksHelper.setOldAttributeNameToNewNodeAttributeNameAndType(mergedNetworkSchemas.getOldAttributeToResolvedNodeSchemaDefinitions(firstNetworkMetadata.getNodeSchema(), secondNetworkMetadata.getNodeSchema()));
        mergeNetworksHelper.setOldAttributeNameToNewEdgeAttributeNameAndType(mergedNetworkSchemas.getOldAttributeToResolvedEdgeSchemaDefinitions(firstNetworkMetadata.getEdgeSchema(), secondNetworkMetadata.getEdgeSchema()));
        if (!this.areResolvedSchemasValid(mergeNetworksHelper)) {
            throw new AlgorithmExecutionException("Errors encountered while resolving attribute names for the merged network.");
        }
        mergeNetworksHelper.setFinalNodeSchema(mergedNetworkSchemas.getFinalNodeSchema(mergeNetworksHelper.getOldAttributeNameToNewNodeAttributeNameAndType()));
        mergeNetworksHelper.setFinalEdgeSchema(mergedNetworkSchemas.getFinalEdgeSchema(mergeNetworksHelper.getOldAttributeNameToNewEdgeAttributeNameAndType()));
        return mergeNetworksHelper;
    }

    private void mergeNetworkNodesAndEdges(File firstInputNetwork, File secondInputNetwork, String nodeIdentifierColumnName, MergeNetworksHelper mergeNetworksHelper, Map<Object, Node> nodeIDToNodeObject, Map<String, Edge> edgeIDToEdgeObject, String firstNetworkName, String secondNetworkName) throws IOException, ParsingException {
        NWBFileParser parser = new NWBFileParser(firstInputNetwork);
        MergeNetworkAssetsComputation mergeNetworkAssetsComputation = new MergeNetworkAssetsComputation(nodeIdentifierColumnName, mergeNetworksHelper.getOldAttributeNameToNewNodeAttributeNameAndType().get((Object)MergedNetworkSchemas.NETWORK_HANDLE.FIRST), mergeNetworksHelper.getOldAttributeNameToNewEdgeAttributeNameAndType().get((Object)MergedNetworkSchemas.NETWORK_HANDLE.FIRST), nodeIDToNodeObject, edgeIDToEdgeObject, firstNetworkName, secondNetworkName, this.logger);
        parser.parse((NWBFileParserHandler)mergeNetworkAssetsComputation);
        parser = new NWBFileParser(secondInputNetwork);
        mergeNetworkAssetsComputation = new MergeNetworkAssetsComputation(nodeIdentifierColumnName, mergeNetworksHelper.getOldAttributeNameToNewNodeAttributeNameAndType().get((Object)MergedNetworkSchemas.NETWORK_HANDLE.SECOND), mergeNetworksHelper.getOldAttributeNameToNewEdgeAttributeNameAndType().get((Object)MergedNetworkSchemas.NETWORK_HANDLE.SECOND), nodeIDToNodeObject, edgeIDToEdgeObject, secondNetworkName, firstNetworkName, this.logger);
        parser.parse((NWBFileParserHandler)mergeNetworkAssetsComputation);
    }

    private NetworkMetadata getNetworkMetadata(File inputNetwork) throws AlgorithmExecutionException {
        NetworkMetadata firstNetworkMetadata = this.validateInputFileAndGetMetadata(inputNetwork);
        if (firstNetworkMetadata == null) {
            throw new AlgorithmExecutionException(String.valueOf(inputNetwork.getName()) + " is not valid.");
        }
        return firstNetworkMetadata;
    }

    private boolean areResolvedSchemasValid(MergeNetworksHelper mergeNetworksHelper) {
        for (Map.Entry<MergedNetworkSchemas.NETWORK_HANDLE, Map<String, NWBAttribute>> currentNodeSchema : mergeNetworksHelper.getOldAttributeNameToNewNodeAttributeNameAndType().entrySet()) {
            if (currentNodeSchema.getValue().size() >= 1) continue;
            return false;
        }
        for (Map.Entry<MergedNetworkSchemas.NETWORK_HANDLE, Map<String, NWBAttribute>> currentEdgeSchema : mergeNetworksHelper.getOldAttributeNameToNewEdgeAttributeNameAndType().entrySet()) {
            if (currentEdgeSchema.getValue().size() >= 2) continue;
            return false;
        }
        return true;
    }

    private Data[] wrapOutData(File nwbFile) {
        BasicData outData = new BasicData((Object)nwbFile, "file:text/nwb");
        Dictionary metaData = outData.getMetadata();
        metaData.put("Label", "Merged Network");
        metaData.put("Type", "Network");
        metaData.put("Parent", this.data[1]);
        return new Data[]{outData};
    }

    private NetworkMetadata validateInputFileAndGetMetadata(File inData) throws AlgorithmExecutionException {
        ValidateNWBFile validateParser = new ValidateNWBFile();
        NetworkMetadata networkMetadata = null;
        try {
            validateParser.validateNWBFormat(inData);
            int numberOfNodes = validateParser.getTotalNumOfNodes();
            int numberOfEdges = validateParser.getTotalNumOfUndirectedEdges();
            boolean isUndirectedNetwork = validateParser.isUndirectedGraph();
            if (isUndirectedNetwork && numberOfEdges >= 0 && numberOfNodes > 1) {
                networkMetadata = new NetworkMetadata(validateParser.getNodeAttrList(), validateParser.getUndirectedEdgeAttrList());
            }
        }
        catch (FileNotFoundException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        return networkMetadata;
    }
}

