/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.mergenetworks;

import edu.iu.nwb.util.nwbfile.GetNWBFileMetadata;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import edu.iu.sci2.preprocessing.mergenetworks.MergeNetworks;
import edu.iu.sci2.preprocessing.mergenetworks.utils.Constants;
import edu.iu.sci2.preprocessing.mergenetworks.utils.NetworkPrefixAttributeDefinition;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCreationFailedException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class MergeNetworksFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String PREFIX_RULES = "\n1. Prefix cannot be empty.\n2. Prefix cannot start with a number.\n3. Prefix for different networks cannot be the same.\n4. Prefix cannot be more than 10 in length.";
    private LogService logger;

    protected void activate(ComponentContext componentContext) {
        this.logger = (LogService)componentContext.locateService("LOG");
    }

    public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        return new MergeNetworks(data, parameters, context);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition parameters) {
        BasicObjectClassDefinition definition;
        File firstNetworkFile = (File)data[0].getData();
        GetNWBFileMetadata firstNetworkMetaDataHandler = new GetNWBFileMetadata();
        File secondNetworkFile = (File)data[1].getData();
        GetNWBFileMetadata secondNetworkMetaDataHandler = new GetNWBFileMetadata();
        try {
            NWBFileParser parser = new NWBFileParser(firstNetworkFile);
            parser.parse((NWBFileParserHandler)firstNetworkMetaDataHandler);
            NWBFileParser parser2 = new NWBFileParser(secondNetworkFile);
            parser2.parse((NWBFileParserHandler)secondNetworkMetaDataHandler);
        }
        catch (IOException e) {
            throw new AlgorithmCreationFailedException(e.getMessage(), (Throwable)e);
        }
        catch (ParsingException e) {
            throw new AlgorithmCreationFailedException(String.valueOf(e.getMessage()) + "One (or both) networks do not conform to NWB File Format.", (Throwable)e);
        }
        try {
            definition = new BasicObjectClassDefinition(parameters.getID(), parameters.getName(), parameters.getDescription(), parameters.getIcon(16));
        }
        catch (IOException iOException) {
            definition = new BasicObjectClassDefinition(parameters.getID(), parameters.getName(), parameters.getDescription(), null);
        }
        if (firstNetworkMetaDataHandler.getDirectedEdgeSchema() != null || secondNetworkMetaDataHandler.getDirectedEdgeSchema() != null) {
            throw new AlgorithmCreationFailedException("Directed networks are not supported currently. Please make sure that both networks are undirected.");
        }
        String[] uniqueIdentifierColumnCandidates = this.getCommonNodeAttributes(firstNetworkMetaDataHandler.getNodeSchema(), secondNetworkMetaDataHandler.getNodeSchema());
        AttributeDefinition[] definitions = parameters.getAttributeDefinitions(-1);
        int ii = 0;
        while (ii < definitions.length) {
            String attributeID = definitions[ii].getID();
            if (attributeID.equals("identifier")) {
                definition.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition(definitions[ii].getID(), definitions[ii].getName(), definitions[ii].getDescription(), definitions[ii].getType(), uniqueIdentifierColumnCandidates, uniqueIdentifierColumnCandidates));
            } else {
                definition.addAttributeDefinition(1, definitions[ii]);
            }
            ++ii;
        }
        NetworkPrefixAttributeDefinition firstPrefixTextbox = new NetworkPrefixAttributeDefinition("firstnetworkprefix", this.getPrefixDisplayName(firstNetworkFile.getName(), "1st"), "This prefix will be used for the first network to resolve attribute name collisions.\n1. Prefix cannot be empty.\n2. Prefix cannot start with a number.\n3. Prefix for different networks cannot be the same.\n4. Prefix cannot be more than 10 in length.", 1, "NETWORK_1", this.logger);
        NetworkPrefixAttributeDefinition secondPrefixTextbox = new NetworkPrefixAttributeDefinition("secondnetworkprefix", this.getPrefixDisplayName(secondNetworkFile.getName(), "2nd"), "This prefix will be used for the second network to resolve attribute name collisions.\n1. Prefix cannot be empty.\n2. Prefix cannot start with a number.\n3. Prefix for different networks cannot be the same.\n4. Prefix cannot be more than 10 in length.", 1, "NETWORK_2", this.logger);
        firstPrefixTextbox.addOtherPrefixTextboxes(secondPrefixTextbox);
        secondPrefixTextbox.addOtherPrefixTextboxes(firstPrefixTextbox);
        definition.addAttributeDefinition(1, (AttributeDefinition)firstPrefixTextbox);
        definition.addAttributeDefinition(1, (AttributeDefinition)secondPrefixTextbox);
        return definition;
    }

    public static String slugify(String textToBeSlugified) {
        String textBlockSeparator = "-";
        return StringUtils.removeEnd((String)StringUtils.substring((String)textToBeSlugified.toLowerCase().trim().replaceAll("[^a-zA-Z0-9-]+", textBlockSeparator), (int)0, (int)10), (String)textBlockSeparator);
    }

    private String getPrefixDisplayName(String name, String networkNumber) {
        return String.valueOf(MergeNetworksFactory.slugify(name)) + " network (" + networkNumber + ") prefix";
    }

    private boolean areThereCommonNodeOrEdgeAttributes(GetNWBFileMetadata firstNetworkMetaDataHandler, GetNWBFileMetadata secondNetworkMetaDataHandler) {
        HashSet commonEdgeAttributes = new HashSet(firstNetworkMetaDataHandler.getUndirectedEdgeSchema().keySet());
        commonEdgeAttributes.retainAll(secondNetworkMetaDataHandler.getUndirectedEdgeSchema().keySet());
        commonEdgeAttributes.removeAll(Constants.NWB_FORMAT_MANDATED_EDGE_ATTRIBUTES);
        if (commonEdgeAttributes.size() > 0) {
            return true;
        }
        HashSet commonNodeAttributes = new HashSet(firstNetworkMetaDataHandler.getNodeSchema().keySet());
        commonNodeAttributes.retainAll(secondNetworkMetaDataHandler.getNodeSchema().keySet());
        commonNodeAttributes.removeAll(Constants.NWB_FORMAT_MANDATED_NODE_ATTRIBUTES);
        return commonNodeAttributes.size() > 0;
    }

    private String[] getCommonNodeAttributes(Map<String, String> firstNetworkNodeSchema, Map<String, String> secondNetworkNodeSchema) {
        HashSet<String> commonNodeAttributes = new HashSet<String>(firstNetworkNodeSchema.keySet());
        commonNodeAttributes.retainAll(secondNetworkNodeSchema.keySet());
        if (commonNodeAttributes.size() < 1) {
            throw new AlgorithmCreationFailedException("No common attribute names found. The two networks provided must have some node attribute names in common, so we know which nodes in the first network correspond to which nodes in the second network.");
        }
        return commonNodeAttributes.toArray(new String[0]);
    }
}

