/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.mergenetworks.utils;

import edu.iu.nwb.converter.nwb.common.NWBAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MergedNetworkSchemas {
    private String firstNetworkCollisionResolvingPrefix;
    private String secondNetworkCollisionResolvingPrefix;
    private Set<String> nodeAttributeNamesToBeIgnored;
    private Set<String> edgeAttributeNamesToBeIgnored;

    public MergedNetworkSchemas(Set<String> nodeAttributeNamesToBeIgnored, Set<String> edgeAttributeNamesToBeIgnored, String firstNetworkCollisionResolvingPrefix, String secondNetworkCollisionResolvingPrefix) {
        this.firstNetworkCollisionResolvingPrefix = firstNetworkCollisionResolvingPrefix;
        this.secondNetworkCollisionResolvingPrefix = secondNetworkCollisionResolvingPrefix;
        this.nodeAttributeNamesToBeIgnored = nodeAttributeNamesToBeIgnored;
        this.edgeAttributeNamesToBeIgnored = edgeAttributeNamesToBeIgnored;
    }

    public Map<NETWORK_HANDLE, Map<String, NWBAttribute>> getOldAttributeToResolvedNodeSchemaDefinitions(List<NWBAttribute> firstNetworkNodeSchema, List<NWBAttribute> secondNetworkNodeSchema) {
        HashMap<NETWORK_HANDLE, Map<String, NWBAttribute>> resolvedNodeSchemas = new HashMap<NETWORK_HANDLE, Map<String, NWBAttribute>>();
        resolvedNodeSchemas.put(NETWORK_HANDLE.FIRST, new LinkedHashMap());
        resolvedNodeSchemas.put(NETWORK_HANDLE.SECOND, new LinkedHashMap());
        HashSet<List<NWBAttribute>> allNodeSchemas = new HashSet<List<NWBAttribute>>();
        allNodeSchemas.add(firstNetworkNodeSchema);
        allNodeSchemas.add(secondNetworkNodeSchema);
        Map firstNetworkOldAttributeNameToNewAttribute = (Map)resolvedNodeSchemas.get((Object)NETWORK_HANDLE.FIRST);
        Map secondNetworkOldAttributeNameToNewAttribute = (Map)resolvedNodeSchemas.get((Object)NETWORK_HANDLE.SECOND);
        firstNetworkOldAttributeNameToNewAttribute.putAll(this.getResolvedSchemaDefinitions(firstNetworkNodeSchema, allNodeSchemas, this.nodeAttributeNamesToBeIgnored, this.firstNetworkCollisionResolvingPrefix));
        secondNetworkOldAttributeNameToNewAttribute.putAll(this.getResolvedSchemaDefinitions(secondNetworkNodeSchema, allNodeSchemas, this.nodeAttributeNamesToBeIgnored, this.secondNetworkCollisionResolvingPrefix));
        return resolvedNodeSchemas;
    }

    public LinkedHashMap<String, String> getFinalNodeSchema(Map<NETWORK_HANDLE, Map<String, NWBAttribute>> oldAttributeToResolvedNodeSchemaDefinitions) {
        LinkedHashMap<String, String> resolvedNodeSchema = new LinkedHashMap<String, String>();
        for (Map.Entry<NETWORK_HANDLE, Map<String, NWBAttribute>> currentNetworkNodeSchema : oldAttributeToResolvedNodeSchemaDefinitions.entrySet()) {
            Map<String, NWBAttribute> oldToResolvedAttribute = currentNetworkNodeSchema.getValue();
            for (Map.Entry<String, NWBAttribute> currentOldToResolvedAttributeName : oldToResolvedAttribute.entrySet()) {
                resolvedNodeSchema.put(currentOldToResolvedAttributeName.getValue().getAttrName(), currentOldToResolvedAttributeName.getValue().getDataType());
            }
        }
        return resolvedNodeSchema;
    }

    public Map<NETWORK_HANDLE, Map<String, NWBAttribute>> getOldAttributeToResolvedEdgeSchemaDefinitions(List<NWBAttribute> firstNetworkEdgeSchema, List<NWBAttribute> secondNetworkEdgeSchema) {
        HashMap<NETWORK_HANDLE, Map<String, NWBAttribute>> resolvedEdgeSchema = new HashMap<NETWORK_HANDLE, Map<String, NWBAttribute>>();
        resolvedEdgeSchema.put(NETWORK_HANDLE.FIRST, new LinkedHashMap());
        resolvedEdgeSchema.put(NETWORK_HANDLE.SECOND, new LinkedHashMap());
        HashSet<List<NWBAttribute>> allEdgeSchemas = new HashSet<List<NWBAttribute>>();
        allEdgeSchemas.add(firstNetworkEdgeSchema);
        allEdgeSchemas.add(secondNetworkEdgeSchema);
        Map firstNetworkOldAttributeNameToNewAttribute = (Map)resolvedEdgeSchema.get((Object)NETWORK_HANDLE.FIRST);
        Map secondNetworkOldAttributeNameToNewAttribute = (Map)resolvedEdgeSchema.get((Object)NETWORK_HANDLE.SECOND);
        firstNetworkOldAttributeNameToNewAttribute.putAll(this.getResolvedSchemaDefinitions(firstNetworkEdgeSchema, allEdgeSchemas, this.edgeAttributeNamesToBeIgnored, this.firstNetworkCollisionResolvingPrefix));
        secondNetworkOldAttributeNameToNewAttribute.putAll(this.getResolvedSchemaDefinitions(secondNetworkEdgeSchema, allEdgeSchemas, this.edgeAttributeNamesToBeIgnored, this.secondNetworkCollisionResolvingPrefix));
        return resolvedEdgeSchema;
    }

    public LinkedHashMap<String, String> getFinalEdgeSchema(Map<NETWORK_HANDLE, Map<String, NWBAttribute>> oldAttributeToResolvedEdgeSchemaDefinitions) {
        LinkedHashMap<String, String> resolvedEdgeSchema = new LinkedHashMap<String, String>();
        for (Map.Entry<NETWORK_HANDLE, Map<String, NWBAttribute>> currentNetworkNodeSchema : oldAttributeToResolvedEdgeSchemaDefinitions.entrySet()) {
            Map<String, NWBAttribute> oldToResolvedAttribute = currentNetworkNodeSchema.getValue();
            for (Map.Entry<String, NWBAttribute> currentOldToResolvedAttributeName : oldToResolvedAttribute.entrySet()) {
                resolvedEdgeSchema.put(currentOldToResolvedAttributeName.getValue().getAttrName(), currentOldToResolvedAttributeName.getValue().getDataType());
            }
            resolvedEdgeSchema.put("present_in_" + this.firstNetworkCollisionResolvingPrefix, "string");
            resolvedEdgeSchema.put("present_in_" + this.secondNetworkCollisionResolvingPrefix, "string");
        }
        return resolvedEdgeSchema;
    }

    private Map<String, NWBAttribute> getResolvedSchemaDefinitions(List<NWBAttribute> originalSchema, Set<List<NWBAttribute>> allSchemas, Set<String> attributeNamesToBeIgnored, String collisionResolvingPrefix) {
        LinkedHashMap<String, NWBAttribute> resolvedSchemaDefinitions = new LinkedHashMap<String, NWBAttribute>();
        for (NWBAttribute currentAttribute : originalSchema) {
            String currentAttributeName = currentAttribute.getAttrName();
            if (this.isAttributePresentInOtherSchemas(currentAttributeName, originalSchema, allSchemas) && !attributeNamesToBeIgnored.contains(currentAttributeName)) {
                resolvedSchemaDefinitions.put(currentAttributeName, new NWBAttribute(this.getResolvedAttributeName(currentAttributeName, collisionResolvingPrefix), currentAttribute.getDataType()));
                continue;
            }
            resolvedSchemaDefinitions.put(currentAttributeName, new NWBAttribute(currentAttributeName, currentAttribute.getDataType()));
        }
        return resolvedSchemaDefinitions;
    }

    private String getResolvedAttributeName(String currentAttributeName, String collisionResolvingPrefix) {
        return String.valueOf(collisionResolvingPrefix) + "_" + currentAttributeName;
    }

    private boolean isAttributePresentInOtherSchemas(String attrName, List<NWBAttribute> originalSchema, Set<List<NWBAttribute>> allNodeSchemas) {
        for (List<NWBAttribute> currentSchema : allNodeSchemas) {
            if (currentSchema == originalSchema) continue;
            for (NWBAttribute currentAttribute : currentSchema) {
                if (!attrName.equalsIgnoreCase(currentAttribute.getAttrName())) continue;
                return true;
            }
        }
        return false;
    }

    public static enum NETWORK_HANDLE {
        FIRST,
        SECOND;

    }
}

