/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.mergenetworks.utils;

import edu.iu.nwb.util.nwbfile.NWBFileUtilities;
import edu.iu.nwb.util.nwbfile.NWBFileWriter;
import edu.iu.sci2.preprocessing.mergenetworks.valueobjects.Edge;
import edu.iu.sci2.preprocessing.mergenetworks.valueobjects.MergeNetworksHelper;
import edu.iu.sci2.preprocessing.mergenetworks.valueobjects.Node;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class MergedNetworkToNWBFileWriter {
    public static File writeMergedNetworkToNWBFile(MergeNetworksHelper mergeNetworksHelper, Map<Object, Node> nodeIDToNodeObject, Map<String, Edge> edgeIdentifierToEdgeObject) throws IOException {
        File outputNWBFile = NWBFileUtilities.createTemporaryNWBFile();
        NWBFileWriter nwbFileWriter = new NWBFileWriter(outputNWBFile);
        nwbFileWriter.setNodeSchema(mergeNetworksHelper.getFinalNodeSchema());
        for (Map.Entry<Object, Node> entry : nodeIDToNodeObject.entrySet()) {
            Node currentNode = entry.getValue();
            nwbFileWriter.addNode(currentNode.getID(), currentNode.getLabel(), currentNode.getAttributes());
        }
        nwbFileWriter.setUndirectedEdgeSchema(mergeNetworksHelper.getFinalEdgeSchema());
        for (Map.Entry<Object, Object> entry : edgeIdentifierToEdgeObject.entrySet()) {
            Edge currentEdge = (Edge)entry.getValue();
            nwbFileWriter.addUndirectedEdge(currentEdge.getSourceID(), currentEdge.getTargetID(), currentEdge.getAttributes());
        }
        nwbFileWriter.finishedParsing();
        return outputNWBFile;
    }
}

