/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.mergenetworks.utils;

import java.util.HashSet;
import java.util.Set;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.utilities.StringUtilities;
import org.osgi.service.log.LogService;

public class NetworkPrefixAttributeDefinition
extends BasicAttributeDefinition {
    private static final int MAX_PREFIX_LENGTH = 10;
    private Set<BasicAttributeDefinition> otherPrefixTextboxes = new HashSet<BasicAttributeDefinition>();
    private String currentValue;
    private LogService logger;

    public String getCurrentValue() {
        return this.currentValue;
    }

    public NetworkPrefixAttributeDefinition(String id, String name, String description, int type, String defaultValue, LogService logService) {
        super(id, name, description, type, defaultValue);
        this.logger = logService;
    }

    public void addOtherPrefixTextboxes(BasicAttributeDefinition otherPrefixTextbox) {
        this.otherPrefixTextboxes.add(otherPrefixTextbox);
    }

    public String validate(String value) {
        this.currentValue = value;
        for (BasicAttributeDefinition currentPrefixTextbox : this.otherPrefixTextboxes) {
            String otherPrefixCurrValue = ((NetworkPrefixAttributeDefinition)currentPrefixTextbox).getCurrentValue();
            if (value == null || otherPrefixCurrValue == null) continue;
            if (StringUtilities.isEmptyOrWhitespace((String)value.trim())) {
                String errorMessage = "Prefix cannot be empty.";
                return errorMessage;
            }
            if (value.trim().matches("[\\d]+.*")) {
                String errorMessage = "Prefix cannot start with a number.";
                return errorMessage;
            }
            if (value.trim().length() > 10) {
                String errorMessage = String.format("Prefix cannot be more than %s in length.", 10);
                return errorMessage;
            }
            if (!value.equalsIgnoreCase(otherPrefixCurrValue)) continue;
            String errorMessage = "Prefix for different networks cannot be the same.";
            return errorMessage;
        }
        return super.validate(value);
    }
}

