/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.scholar;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.TableUtilities;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class GenericPublicationAlgorithm
implements Algorithm {
    private Data[] data;
    private Dictionary<String, Object> parameters;
    LogService log;

    public GenericPublicationAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        this.data = data;
        this.parameters = parameters;
        this.log = (LogService)ciShellContext.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table inputTable = (Table)this.data[0].getData();
        String filePath = this.parameters.get("file").toString();
        Table finalTable = null;
        try {
            URL configUrl = new File(filePath).toURI().toURL();
            finalTable = TableUtilities.standardizeTable((URL)configUrl, (Table)inputTable);
        }
        catch (IOException iOException) {
            String errorMsg = "An error occurred while attempting to read the properties file. Please check that a properly formatted header map file, with a .hmap file extension, was selected. Please see this wiki page for details on the .hmap specification: http://wiki.cns.iu.edu/display/SCI2TUTORIAL/3.8+Header+Map+Files";
            throw new AlgorithmExecutionException(errorMsg);
        }
        Data[] outputData = this.formatAsData(finalTable);
        return outputData;
    }

    private Data[] formatAsData(Table inputTable) throws AlgorithmExecutionException {
        try {
            Data[] dm = new Data[]{new BasicData((Object)inputTable, Table.class.getName())};
            dm[0].getMetadata().put("Label", "Table with Generic Headers");
            dm[0].getMetadata().put("Type", "Table");
            dm[0].getMetadata().put("Parent", this.data[0]);
            return dm;
        }
        catch (SecurityException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }
}

