/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.scimaps;

import edu.iu.sci2.preprocessing.scimaps.journal.ScimapsJournalMatcher;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Iterator;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.Data;
import org.cishell.utilities.DataFactory;
import org.cishell.utilities.TableUtilities;
import org.osgi.service.log.LogService;
import prefuse.data.Table;
import prefuse.data.Tuple;

public class JournalNamingConvention
implements Algorithm {
    private static final String STANDARDIZED_JOURNAL_NAME_COLUMN = "Reconciled Journal Name";
    private Data[] data;
    private String journalColumnName;
    private LogService logger;

    public JournalNamingConvention(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        this.data = data;
        this.logger = (LogService)ciShellContext.getService(LogService.class.getName());
        this.journalColumnName = parameters.get("journal").toString();
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table outputTable;
        Table table = (Table)this.data[0].getData();
        try {
            outputTable = this.processJournalName(table);
        }
        catch (IOException e) {
            this.logger.log(4, "Failed to instialize journal parser.", (Throwable)e);
            throw new AlgorithmExecutionException("Failed to instialize journal parser.");
        }
        return this.prepareOutputData(outputTable);
    }

    private Table processJournalName(Table table) throws IOException {
        ScimapsJournalMatcher scimapsJournalMatcher = new ScimapsJournalMatcher();
        Table outputTable = TableUtilities.copyTable((Table)table);
        outputTable.addColumn(STANDARDIZED_JOURNAL_NAME_COLUMN, String.class);
        int standardizedJournalNameColumnIndex = outputTable.getColumnNumber(STANDARDIZED_JOURNAL_NAME_COLUMN);
        Iterator rows = outputTable.tuples();
        int rowIndex = 0;
        while (rows.hasNext()) {
            Tuple row = (Tuple)rows.next();
            if (row.canGetString(this.journalColumnName)) {
                String name = row.getString(this.journalColumnName);
                String suggestedName = scimapsJournalMatcher.get(name);
                outputTable.setString(rowIndex, standardizedJournalNameColumnIndex, suggestedName);
            }
            ++rowIndex;
        }
        return outputTable;
    }

    private Data[] prepareOutputData(Table table) {
        Data[] outputData = new Data[]{DataFactory.forObject((Object)table, (String)Table.class.getName(), (String)"Table", (Data)this.data[0], (String)"Standardized Journal Names")};
        return outputData;
    }
}

