/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.preprocessing.scimaps.journal;

import au.com.bytecode.opencsv.CSVReader;
import edu.iu.sci2.preprocessing.scimaps.journal.TextNormalizer;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ScimapsJournalMatcher {
    private static final String JOURNAL_FULL_NAME = "journ_names_05.14.13.csv";
    private static final String JOURNAL_ALTERNATIVE_NAME = "journ_alt_names_05.14.13.csv";
    private Map<String, Integer> normalizedNameToId = new HashMap<String, Integer>();
    private HashMap<Integer, String> idToFullName = new HashMap();

    public ScimapsJournalMatcher() throws IOException {
        this.initJournalMap();
    }

    public String get(String name) {
        String normalizedName = TextNormalizer.normalize(name);
        Integer id = this.normalizedNameToId.get(normalizedName);
        return id == null ? null : this.idToFullName.get(id);
    }

    private void initJournalMap() throws IOException {
        String normalizedName;
        Integer id;
        String[] line;
        CSVReader reader = null;
        URL url = ScimapsJournalMatcher.class.getResource(JOURNAL_FULL_NAME);
        try {
            reader = new CSVReader((Reader)new InputStreamReader(url.openStream()));
            line = reader.readNext();
            while ((line = reader.readNext()) != null) {
                if (line.length <= 1) continue;
                id = Integer.parseInt(line[0].trim());
                normalizedName = TextNormalizer.normalize(line[1]);
                this.normalizedNameToId.put(normalizedName, id);
                this.idToFullName.put(id, line[1]);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
        url = ScimapsJournalMatcher.class.getResource(JOURNAL_ALTERNATIVE_NAME);
        try {
            reader = new CSVReader((Reader)new InputStreamReader(url.openStream()));
            line = reader.readNext();
            while ((line = reader.readNext()) != null) {
                if (line.length <= 1) continue;
                id = Integer.parseInt(line[0].trim());
                normalizedName = TextNormalizer.normalize(line[1]);
                this.normalizedNameToId.put(normalizedName, id);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
    }
}

