/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.facebook.FacebookFriend;

import edu.iu.sci2.reader.facebook.utilities.CallAPI;
import edu.iu.sci2.reader.facebook.utilities.FacebookUtilities;
import edu.iu.sci2.reader.facebook.utilities.FriendObject;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class FacebookFriends
implements Algorithm {
    private LogService logger;
    private HashMap<String, FriendObject> idDataList;
    private String token;

    public FacebookFriends(CIShellContext ciShellContext, String token) {
        this.logger = (LogService)ciShellContext.getService(LogService.class.getName());
        this.token = token;
        this.idDataList = new HashMap();
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table table = null;
        if (!FacebookUtilities.isValidToken(this.token, this.logger)) {
            this.logger.log(1, "You have failed to submit a valid access token. The time has either expired on your current access token, or you did not provide one. Please obtain a new access token by going to \"Facebook->Access Token\" on the File menu.");
            return null;
        }
        table = this.getFriendsData(this.token);
        return this.generateOutData(table);
    }

    private Table getFriendsData(String token) throws AlgorithmExecutionException {
        String data = "access_token=" + token;
        Table table = null;
        try {
            JSONObject friendsObj = new JSONObject(CallAPI.FriendsDataAPI(data, this.logger));
            JSONArray friendsArray = friendsObj.getJSONArray("data");
            int i = 0;
            while (i < friendsArray.length()) {
                JSONObject currentResult = friendsArray.getJSONObject(i);
                Long id = currentResult.getLong("uid");
                FriendObject fd = new FriendObject(id);
                fd.setName(currentResult.getString("name"));
                fd.setId(id);
                fd.setGender(currentResult.getString("sex"));
                fd.setHomeTownLocation(FacebookUtilities.getFriendsHometown(currentResult));
                fd.setCurrentLocation(FacebookUtilities.getFriendsCurrentLocation(currentResult));
                fd.setStatus(FacebookUtilities.getStatus(currentResult));
                fd.setInterest(FacebookUtilities.getInterests(currentResult));
                fd.setBirthday(FacebookUtilities.getBirthday(currentResult));
                fd.setReligion(FacebookUtilities.getReligion(currentResult));
                fd.setPoliticalView(FacebookUtilities.getPolitical(currentResult));
                fd.setRelationShipStatus(FacebookUtilities.getRelationship(currentResult));
                this.idDataList.put(id.toString(), fd);
                ++i;
            }
            JSONObject obj = new JSONObject(CallAPI.FriendsEventAPI(data, this.logger));
            JSONArray jsonArrayEvent = obj.getJSONArray("data");
            HashMap<Long, String> eventIdToName = new HashMap<Long, String>();
            int i2 = 0;
            while (i2 < jsonArrayEvent.length()) {
                JSONObject currentResult = jsonArrayEvent.getJSONObject(i2);
                String eventName = currentResult.getString("name");
                Long id = currentResult.getLong("eid");
                eventIdToName.put(id, eventName);
                ++i2;
            }
            obj = new JSONObject(CallAPI.FriendsCommonEventAPI(data, this.logger));
            JSONArray jsonArrayCommonEvent = obj.getJSONArray("data");
            int i3 = 0;
            while (i3 < jsonArrayCommonEvent.length()) {
                JSONObject currentResult = jsonArrayCommonEvent.getJSONObject(i3);
                Long uid = currentResult.getLong("uid");
                Long eid = currentResult.getLong("eid");
                FriendObject fd = this.idDataList.get(uid.toString());
                if (fd != null && eid != null && eventIdToName.get(eid) != null) {
                    fd.addEvent(((String)eventIdToName.get(eid)).replace("|", ","));
                }
                ++i3;
            }
            table = this.generateTabularData(this.idDataList);
        }
        catch (JSONException e) {
            throw new AlgorithmExecutionException("An error has occurred while trying to reach the authentication URL. Please report to cns-sci2-help-l@iulist.indiana.edu", (Throwable)e);
        }
        return table;
    }

    public Table generateTabularData(HashMap<String, FriendObject> map) {
        Table table = new Table();
        table.addColumn("Person Name", String.class);
        table.addColumn("Facebook Id", Long.class);
        table.addColumn("Status", String.class);
        table.addColumn("Gender", String.class);
        table.addColumn("Current Location", String.class);
        table.addColumn("Hometown", String.class);
        table.addColumn("Birthday", String.class);
        table.addColumn("Interests", String.class);
        table.addColumn("Religion", String.class);
        table.addColumn("Political View", String.class);
        table.addColumn("Relationship Status", String.class);
        table.addColumn("Events", String.class);
        for (Map.Entry<String, FriendObject> entry : map.entrySet()) {
            FriendObject data = entry.getValue();
            List<String> eventArray = data.getEventList();
            String eventStr = "";
            if (!eventArray.isEmpty()) {
                for (String event : eventArray) {
                    eventStr = String.valueOf(eventStr) + event + "|";
                }
                eventStr = eventStr.substring(0, eventStr.length() - 1);
            }
            int rowNumber = table.addRow();
            table.set(rowNumber, "Person Name", (Object)data.getName());
            table.set(rowNumber, "Facebook Id", (Object)data.getId());
            table.set(rowNumber, "Status", (Object)data.getStatus());
            table.set(rowNumber, "Gender", (Object)data.getGender());
            table.set(rowNumber, "Current Location", (Object)data.getCurrentLocation());
            table.set(rowNumber, "Hometown", (Object)data.getHomeTownLocation());
            table.set(rowNumber, "Birthday", (Object)data.getBirthday());
            table.set(rowNumber, "Interests", (Object)data.getInterest());
            table.set(rowNumber, "Religion", (Object)data.getReligion());
            table.set(rowNumber, "Political View", (Object)data.getPoliticalView());
            table.set(rowNumber, "Relationship Status", (Object)data.getRelationShipStatus());
            table.set(rowNumber, "Events", (Object)eventStr);
        }
        this.logger.log(3, "Please check the Data Manager for generated data.");
        return table;
    }

    private Data[] generateOutData(Table table) {
        BasicData output = new BasicData((Object)table, Table.class.getName());
        Dictionary metadata = output.getMetadata();
        metadata.put("Label", "FacebookFriendsData");
        metadata.put("Type", "Table");
        return new Data[]{output};
    }
}

