/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.facebook.FriendsNetwork;

import edu.iu.sci2.reader.facebook.utilities.CallAPI;
import edu.iu.sci2.reader.facebook.utilities.FacebookUtilities;
import edu.iu.sci2.reader.facebook.utilities.FriendPair;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class FriendsNetwork
implements Algorithm {
    private LogService logger;
    private List<FriendPair> pairList;
    private String token;
    private String data;

    public FriendsNetwork(CIShellContext ciShellContext, String token) {
        this.token = token;
        this.data = "access_token=" + token;
        this.logger = (LogService)ciShellContext.getService(LogService.class.getName());
        this.pairList = new ArrayList<FriendPair>();
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table table = null;
        if (!FacebookUtilities.isValidToken(this.token, this.logger)) {
            this.logger.log(1, "You have failed to submit a valid access token. The time has either expired on your current access token, or you did not provide one. Please obtain a new access token by going to \"Facebook->Access Token\" on the File menu.");
            return null;
        }
        table = this.getFriendsNetwork(this.token);
        return this.generateOutData(table);
    }

    public Table getFriendsNetwork(String token) throws AlgorithmExecutionException {
        Table table = null;
        HashMap<Long, String> idToName = new HashMap<Long, String>();
        try {
            JSONObject currentResult;
            String myName = FacebookUtilities.getMyName(this.data, this.logger);
            String myId = FacebookUtilities.getMyId(this.data, this.logger);
            idToName.put(Long.parseLong(myId), myName);
            JSONObject friendsObj = new JSONObject(CallAPI.MyFriendsAPI(this.data, this.logger));
            JSONArray jsonFriendsArray = friendsObj.getJSONArray("data");
            int i = 0;
            while (i < jsonFriendsArray.length()) {
                JSONObject currentResult2 = jsonFriendsArray.getJSONObject(i);
                String friendOneName = currentResult2.getString("name");
                Long id = currentResult2.getLong("id");
                idToName.put(id, friendOneName);
                this.pairList.add(new FriendPair(myName, friendOneName));
                ++i;
            }
            JSONObject mutualFriendsObject = new JSONObject(CallAPI.MutualFriendsAPI(this.data, this.logger));
            JSONArray jsonMutualArray = mutualFriendsObject.getJSONArray("data");
            JSONObject friendsEventObj = new JSONObject(CallAPI.FriendsEventAPI(this.data, this.logger));
            JSONArray jsonEventArr = friendsEventObj.getJSONArray("data");
            HashMap<Long, String> eventIdToName = new HashMap<Long, String>();
            int i2 = 0;
            while (i2 < jsonEventArr.length()) {
                JSONObject currentResult3 = jsonEventArr.getJSONObject(i2);
                String eventName = currentResult3.getString("name");
                Long id = currentResult3.getLong("eid");
                eventIdToName.put(id, eventName.replace("|", ","));
                ++i2;
            }
            JSONObject friendsCommonEventObject = new JSONObject(CallAPI.FriendsCommonEventAPI(this.data, this.logger));
            JSONArray jsonCommonEventArr = friendsCommonEventObject.getJSONArray("data");
            HashMap<Long, ArrayList> commonEvents = new HashMap<Long, ArrayList>();
            int i3 = 0;
            while (i3 < jsonCommonEventArr.length()) {
                ArrayList uidList;
                currentResult = jsonCommonEventArr.getJSONObject(i3);
                Long uid = currentResult.getLong("uid");
                Long eid = currentResult.getLong("eid");
                if (commonEvents.get(eid) == null) {
                    uidList = new ArrayList();
                    uidList.add((String)idToName.get(uid));
                    commonEvents.put(eid, uidList);
                } else {
                    uidList = (ArrayList)commonEvents.get(eid);
                    uidList.add((String)idToName.get(uid));
                    commonEvents.put(eid, uidList);
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < jsonMutualArray.length()) {
                currentResult = jsonMutualArray.getJSONObject(i3);
                Long id1 = currentResult.getLong("uid1");
                Long id2 = currentResult.getLong("uid2");
                FriendPair fp = new FriendPair((String)idToName.get(id1), (String)idToName.get(id2));
                this.pairList.add(fp);
                ++i3;
            }
            JSONObject MutualFriendsNumObject = new JSONObject(CallAPI.NumberOfMutualFriendsAPI(this.data, this.logger));
            JSONArray jsonMutualFriendsNum = MutualFriendsNumObject.getJSONArray("data");
            HashMap<String, Long> nameToNumMap = new HashMap<String, Long>();
            int i4 = 0;
            while (i4 < jsonMutualFriendsNum.length()) {
                JSONObject currentResult4 = jsonMutualFriendsNum.getJSONObject(i4);
                String name = currentResult4.getString("name");
                Long numOfMutualFriends = currentResult4.getLong("mutual_friend_count");
                nameToNumMap.put(name, numOfMutualFriends);
                ++i4;
            }
            for (FriendPair fp : this.pairList) {
                for (Map.Entry entry : commonEvents.entrySet()) {
                    ArrayList uid = (ArrayList)entry.getValue();
                    if (uid.contains(fp.getName1()) && uid.contains(fp.getName2())) {
                        fp.setCommonEvent((String)eventIdToName.get(entry.getKey()));
                    }
                    if (fp.getName1() != myName || !nameToNumMap.containsKey(fp.getName2())) continue;
                    fp.setNumOfMutualFriends((Long)nameToNumMap.get(fp.getName2()));
                }
            }
            table = this.generateTabularData(this.pairList);
        }
        catch (JSONException e) {
            throw new AlgorithmExecutionException("An error has occurred while trying to reach the authentication URL. Please report to cns-sci2-help-l@iulist.indiana.edu", (Throwable)e);
        }
        return table;
    }

    public Table generateTabularData(List<FriendPair> list) {
        Table table = new Table();
        table.addColumn("Facebook User 1", String.class);
        table.addColumn("Facebook User 2", String.class);
        table.addColumn("Number of Common Events Attended", Integer.class);
        table.addColumn("Number Of Mutual Friends", String.class);
        for (FriendPair pair : list) {
            int rowNumber = table.addRow();
            table.set(rowNumber, "Facebook User 1", (Object)pair.getName1());
            table.set(rowNumber, "Facebook User 2", (Object)pair.getName2());
            table.set(rowNumber, "Number of Common Events Attended", (Object)pair.getNumberOfCommonEvents());
            table.set(rowNumber, "Number Of Mutual Friends", (Object)pair.getNumOfMutualFriends().toString());
        }
        return table;
    }

    private Data[] generateOutData(Table table) {
        BasicData output = new BasicData((Object)table, Table.class.getName());
        Dictionary metadata = output.getMetadata();
        metadata.put("Label", "MutualFriendsNetwork");
        metadata.put("Type", "Table");
        return new Data[]{output};
    }
}

