/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.facebook.utilities;

import edu.iu.sci2.reader.facebook.utilities.CallAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.osgi.service.log.LogService;

public final class FacebookUtilities {
    public static final int DEFAULT_NUMBER_OF_RETRIES = 3;
    public static final int BUFFER_SIZE = 4096;
    public static final String DownloadHandler = null;

    private FacebookUtilities() {
    }

    public static boolean isValidToken(String token, LogService logger) throws AlgorithmExecutionException {
        if (!token.isEmpty()) {
            token = "access_token=" + token;
            String data = CallAPI.DetailsAPI(token, logger);
            try {
                new JSONObject(new JSONTokener(data));
            }
            catch (JSONException jSONException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static String formatDate(String str) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("January", "01");
        map.put("February", "02");
        map.put("March", "03");
        map.put("April", "04");
        map.put("May", "05");
        map.put("June", "06");
        map.put("July", "07");
        map.put("August", "08");
        map.put("September", "09");
        map.put("October", "10");
        map.put("November", "11");
        map.put("December", "12");
        if (str.contains(",")) {
            String[] array = str.split(",");
            String monthDay = array[0];
            String[] mDArray = monthDay.split(" ");
            String month = (String)map.get(mDArray[0]);
            String year = array[1];
            String day = mDArray[1];
            if (day.length() == 1) {
                day = "0" + day;
            }
            return String.valueOf(year) + "-" + month + "-" + day;
        }
        String[] mDArray = str.split(" ");
        String month = (String)map.get(mDArray[0]);
        String day = mDArray[1];
        if (day.length() == 1) {
            day = "0" + day;
        }
        return String.valueOf(month) + "-" + day;
    }

    public static String getMyName(String token, LogService logger) throws JSONException, AlgorithmExecutionException {
        String data = CallAPI.DetailsAPI(token, logger);
        JSONObject obj = new JSONObject(new JSONTokener(data));
        return obj.getString("name");
    }

    public static String getMyId(String token, LogService logger) throws JSONException, AlgorithmExecutionException {
        String data = CallAPI.DetailsAPI(token, logger);
        JSONObject obj = new JSONObject(new JSONTokener(data));
        return obj.getString("id");
    }

    public static String getFriendsHometown(JSONObject currentResult) throws JSONException {
        String ht = null;
        if (!currentResult.isNull("hometown_location")) {
            JSONObject htObj = currentResult.getJSONObject("hometown_location");
            String name = "";
            String state = "";
            String country = "";
            String zip = "";
            if (!htObj.isNull("name")) {
                name = String.valueOf(htObj.getString("name")) + ",";
            }
            if (!htObj.isNull("state")) {
                state = String.valueOf(htObj.getString("state")) + ",";
            }
            if (!htObj.isNull("country")) {
                country = String.valueOf(htObj.getString("country")) + ",";
            }
            if (!htObj.isNull("zip")) {
                zip = htObj.getString("zip");
            }
            ht = FacebookUtilities.removeDuplicates(String.valueOf(name) + state + country + zip);
        }
        return ht;
    }

    private static String removeDuplicates(String str) {
        HashSet<String> hset = new HashSet<String>();
        String[] strList = str.split(",");
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = strList;
        int n = strList.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if (!(val = val.trim()).isEmpty() && !hset.contains(val)) {
                hset.add(val);
                list.add(val);
            }
            ++n2;
        }
        Object[] outStringList = list.toArray(new String[0]);
        String outString = Arrays.toString(outStringList).replace("[", "").replace("]", "");
        return outString;
    }

    public static String getFriendsCurrentLocation(JSONObject currentResult) throws JSONException {
        String cl = null;
        if (!currentResult.isNull("current_location")) {
            JSONObject htObj = currentResult.getJSONObject("current_location");
            String state = "";
            String name = "";
            String city = "";
            String country = "";
            String zip = "";
            if (!htObj.isNull("name")) {
                name = String.valueOf(htObj.getString("name")) + ",";
            }
            if (!htObj.isNull("city")) {
                city = String.valueOf(htObj.getString("city")) + ",";
            }
            if (!htObj.isNull("state")) {
                state = String.valueOf(htObj.getString("state")) + ",";
            }
            if (!htObj.isNull("country")) {
                country = String.valueOf(htObj.getString("country")) + ",";
            }
            if (!htObj.isNull("zip")) {
                zip = htObj.getString("zip");
            }
            cl = FacebookUtilities.removeDuplicates(String.valueOf(name) + city + state + country + zip);
        }
        return cl;
    }

    public static String getStatus(JSONObject currentResult) throws JSONException {
        String message = null;
        if (!currentResult.isNull("status")) {
            JSONObject jsonObj = currentResult.getJSONObject("status");
            message = jsonObj.getString("message");
        }
        return message;
    }

    public static String getInterests(JSONObject currentResult) throws JSONException {
        String interests = null;
        if (!currentResult.isNull("interests")) {
            interests = currentResult.getString("interests").replace(",", "|");
        }
        return interests;
    }

    public static String getBirthday(JSONObject currentResult) throws JSONException {
        String birthday = null;
        if (!currentResult.isNull("birthday")) {
            birthday = FacebookUtilities.formatDate(currentResult.getString("birthday"));
        }
        return birthday;
    }

    public static String getReligion(JSONObject currentResult) throws JSONException {
        String religion = null;
        if (!currentResult.isNull("religion")) {
            religion = currentResult.getString("religion");
        }
        return religion;
    }

    public static String getPolitical(JSONObject currentResult) throws JSONException {
        String political = null;
        if (!currentResult.isNull("political")) {
            political = currentResult.getString("political");
        }
        return political;
    }

    public static String getRelationship(JSONObject currentResult) throws JSONException {
        String relationship = null;
        if (!currentResult.isNull("relationship_status")) {
            relationship = currentResult.getString("relationship_status");
        }
        return relationship;
    }
}

