/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.flickr;

import edu.iu.sci2.reader.flickr.FlickrRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class Flickr {
    private String apiKey;
    private String method;
    private Map<String, String> parameters = new HashMap<String, String>();
    private String baseURL;

    public Flickr(String baseURL, String apiKey, String method, Map<String, String> parameters) {
        this.baseURL = baseURL;
        this.apiKey = apiKey;
        this.method = method;
        this.parameters = parameters;
    }

    public Map<String, String> getParameters() {
        if (this.parameters.keySet().isEmpty()) {
            throw new FlickrRuntimeException("Parameters not set");
        }
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setApiKey(String newApiKey) {
        this.apiKey = newApiKey;
    }

    public String getApiKey() {
        if (this.apiKey == null) {
            throw new FlickrRuntimeException("API Key not set");
        }
        return this.apiKey;
    }

    public String getMethod() {
        if (this.method == null) {
            throw new FlickrRuntimeException("Method not set");
        }
        return this.method;
    }

    public void setMethod(String newMethod) {
        this.method = newMethod;
    }

    public void setBaseURL(String newBaseURL) {
        this.baseURL = newBaseURL;
    }

    public String getBaseURL() {
        if (this.baseURL == null) {
            throw new FlickrRuntimeException("BaseURL not set");
        }
        return this.baseURL;
    }

    public InputStream callMethod(int requestType) throws IOException {
        String urlString = this.getURL(requestType);
        URL url = new URL(urlString);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        InputStream in = null;
        switch (requestType) {
            case 0: {
                con.setRequestMethod("GET");
                con.setDoOutput(false);
                con.setDoInput(true);
                con.connect();
                in = con.getInputStream();
                break;
            }
            case 1: {
                con.setRequestMethod("POST");
                con.setDoOutput(true);
                con.setDoInput(true);
                con.connect();
                OutputStream out = con.getOutputStream();
                String param = this.getParams();
                byte[] buff = param.getBytes("UTF8");
                out.write(buff);
                out.flush();
                out.close();
                in = con.getInputStream();
            }
        }
        return in;
    }

    private String getURL(int requestType) {
        String requestURL = this.baseURL;
        if (requestType == 0) {
            requestURL = String.valueOf(requestURL) + "?" + this.getParams();
        }
        return requestURL;
    }

    private String getParams() {
        String requestParam = "";
        try {
            requestParam = String.valueOf(URLEncoder.encode("method", "UTF-8")) + "=" + URLEncoder.encode(this.getMethod(), "UTF-8") + "&";
            requestParam = String.valueOf(requestParam) + URLEncoder.encode("api_key", "UTF-8") + "=" + URLEncoder.encode(this.getApiKey(), "UTF-8") + "&";
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            throw new Error("Unsupported Encoding Exception", ex);
        }
        boolean first = true;
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            try {
                if (first) {
                    first = false;
                } else {
                    requestParam = String.valueOf(requestParam) + "&";
                }
                requestParam = String.valueOf(requestParam) + URLEncoder.encode(entry.getKey(), "UTF-8") + "=" + URLEncoder.encode(entry.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
                throw new Error("Unsupported Encoding Exception", ex);
            }
        }
        return requestParam;
    }
}

