/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.flickr;

import edu.iu.sci2.reader.flickr.FlickrImageGainer;
import edu.iu.sci2.reader.flickr.FlickrResult;
import edu.iu.sci2.reader.flickr.FlickrRuntimeException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;
import prefuse.data.Table;
import prefuse.data.util.TableIterator;

public class FlickrReader
implements Algorithm {
    public static final String USER_COLUMN_TITLE = "Flickr UserID";
    public static final String IMAGE_URL_COLUMN_TITLE = "Image URL";
    public static final String USERNAME_COLUMN_TITLE = "User Name";
    public static final String TITLE_COLUMN_TITLE = "Title";
    public static final String DATE_COLUMN_TITLE = "Taken At";
    private LogService logger;
    private Data[] data;
    private String userIDColumn;
    private String tag;
    private String apiKey;

    public FlickrReader(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        this.logger = (LogService)ciShellContext.getService(LogService.class.getName());
        this.data = data;
        this.userIDColumn = parameters.get("uid").toString();
        this.apiKey = parameters.get("apikey").toString();
        this.tag = parameters.get("tag").toString();
    }

    public static void main(String[] args) {
        FlickrImageGainer imageGainer = new FlickrImageGainer("4f6ed3c0e47e7c633016933f0b0eb884");
        imageGainer.getImageResults("NBA", "81872511@N08");
    }

    public Data[] execute() throws AlgorithmExecutionException {
        List<String> userIDs = this.extractUserIDsFromTable();
        FlickrImageGainer imageGainer = new FlickrImageGainer(this.apiKey);
        HashMap<String, List<FlickrResult>> uidToResultsMap = new HashMap<String, List<FlickrResult>>();
        try {
            for (String uID : userIDs) {
                this.logger.log(3, String.format("Downloading image URLs for user %s.", uID));
                List<FlickrResult> resultList = imageGainer.getImageResults(this.tag, uID);
                if (resultList.isEmpty()) continue;
                uidToResultsMap.put(uID, resultList);
            }
        }
        catch (FlickrRuntimeException e) {
            throw new AlgorithmExecutionException("Flickr service or network is unavailable. Try again later", (Throwable)e);
        }
        Table resultTable = this.covertResultIntoTable(uidToResultsMap);
        return this.generateOutputData(resultTable);
    }

    private List<String> extractUserIDsFromTable() {
        ArrayList<String> userIDs = new ArrayList<String>();
        Table inputTable = (Table)this.data[0].getData();
        int userIDColumnIndex = inputTable.getColumnNumber(this.userIDColumn);
        TableIterator rowsIterator = inputTable.iterator();
        while (rowsIterator.hasNext()) {
            int currentRowNumber = Integer.parseInt(rowsIterator.next().toString());
            String userID = inputTable.get(currentRowNumber, userIDColumnIndex).toString();
            userIDs.add(userID);
        }
        return userIDs;
    }

    private Table covertResultIntoTable(Map<String, List<FlickrResult>> uidToResultsMap) {
        Integer count = 0;
        Table table = new Table();
        table.addColumn(USER_COLUMN_TITLE, String.class);
        table.addColumn(USERNAME_COLUMN_TITLE, String.class);
        table.addColumn(TITLE_COLUMN_TITLE, String.class);
        table.addColumn(DATE_COLUMN_TITLE, String.class);
        table.addColumn(IMAGE_URL_COLUMN_TITLE, String.class);
        for (Map.Entry<String, List<FlickrResult>> entry : uidToResultsMap.entrySet()) {
            String uid = entry.getKey();
            List<FlickrResult> results = entry.getValue();
            count = count + results.size();
            for (FlickrResult ret : results) {
                int rowNumber = table.addRow();
                table.set(rowNumber, USER_COLUMN_TITLE, (Object)uid);
                table.set(rowNumber, USERNAME_COLUMN_TITLE, (Object)ret.getUsername());
                table.set(rowNumber, TITLE_COLUMN_TITLE, (Object)ret.getTitle());
                table.set(rowNumber, DATE_COLUMN_TITLE, (Object)ret.getDate());
                table.set(rowNumber, IMAGE_URL_COLUMN_TITLE, (Object)ret.getUrl());
            }
        }
        this.logger.log(3, String.format("There are %d image URLs downloaded.", count));
        return table;
    }

    private Data[] generateOutputData(Table table) {
        BasicData output = new BasicData((Object)table, Table.class.getName());
        Dictionary metadata = output.getMetadata();
        metadata.put("Label", "FlickrResult");
        metadata.put("Parent", this.data[0]);
        metadata.put("Type", "Table");
        return new Data[]{output};
    }
}

