/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.googlescholar;

import edu.iu.sci2.reader.googlescholar.AbstractCitationAlgorithmFactory;
import edu.iu.sci2.reader.googlescholar.citationindicies.AuthorIndicesExtractor;
import edu.iu.sci2.reader.googlescholar.citationindicies.IndicesRecord;
import edu.iu.sci2.reader.googlescholar.citationindicies.IndicesRecordTable;
import edu.iu.sci2.reader.googlescholar.search.GoogleScholarReaderHelper;
import java.util.Set;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.Data;
import org.cishell.utilities.DataFactory;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class CitationIndiciesAlgorithm
implements Algorithm {
    private Data[] data;
    private LogService logger;
    private String userIdColumnName;
    private String delimiter;

    public CitationIndiciesAlgorithm(Data[] data, String userIdColumnName, String delimiter, CIShellContext ciShellContext) {
        this.data = data;
        this.userIdColumnName = userIdColumnName;
        this.delimiter = delimiter;
        this.logger = (LogService)ciShellContext.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table inputTable = (Table)this.data[0].getData();
        Set<String> uniqueUserIds = GoogleScholarReaderHelper.getUniqueAuthors(inputTable, this.userIdColumnName, this.delimiter, this.logger);
        Table table = this.getAuthorIndicesTable(uniqueUserIds, this.logger);
        this.logger.log(3, "Total user id on file: " + uniqueUserIds.size());
        this.logger.log(3, "Total user id found: " + table.getRowCount());
        this.logger.log(3, "Total user id not found: " + (uniqueUserIds.size() - table.getRowCount()));
        return this.prepareOutputData(table);
    }

    private Table getAuthorIndicesTable(Set<String> userIds, LogService logger) throws AlgorithmExecutionException {
        IndicesRecordTable indicesRecordTable = new IndicesRecordTable();
        for (String userId : userIds) {
            try {
                IndicesRecord indicesRecord = AuthorIndicesExtractor.getAuthorIndices(userId);
                indicesRecordTable.addIndicesRecord(indicesRecord);
            }
            catch (AuthorIndicesExtractor.IndexExtractionException e) {
                throw new AlgorithmExecutionException((Throwable)e);
            }
            catch (Exception exception) {
                logger.log(3, String.valueOf(userId) + ": Profile not found for the given user ID!!");
            }
        }
        return indicesRecordTable.getTable();
    }

    private Data[] prepareOutputData(Table table) {
        Data[] outputData = new Data[]{DataFactory.forObject((Object)table, (String)Table.class.getName(), (String)"Table", (Data)this.data[0], (String)"Author Indices")};
        return outputData;
    }

    public static class Factory
    extends AbstractCitationAlgorithmFactory {
        @Override
        protected Algorithm createAlgorithm(Data[] data, String userIdColumnName, String delimiter, CIShellContext ciShellContext) {
            return new CitationIndiciesAlgorithm(data, userIdColumnName, delimiter, ciShellContext);
        }
    }
}

