/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.googlescholar;

import edu.iu.sci2.reader.googlescholar.AbstractCitationAlgorithmFactory;
import edu.iu.sci2.reader.googlescholar.citationtable.CitationTableExtractor;
import edu.iu.sci2.reader.googlescholar.search.GoogleScholarReaderHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.Data;
import org.cishell.utilities.DataFactory;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class CitationTableAlgorithm
implements Algorithm {
    private Data[] data;
    private LogService logger;
    private String delimiter = null;
    private String userIdColumnName;

    public CitationTableAlgorithm(Data[] data, String userIdColumnName, String delimiter, CIShellContext ciShellContext) {
        this.data = data;
        this.userIdColumnName = userIdColumnName;
        this.delimiter = delimiter;
        this.logger = (LogService)ciShellContext.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table inputTable = (Table)this.data[0].getData();
        Set<String> uniqueUserIds = GoogleScholarReaderHelper.getUniqueAuthors(inputTable, this.userIdColumnName, this.delimiter, this.logger);
        Map<String, Table> outputMap = this.getAuthorCitations(uniqueUserIds);
        this.logger.log(3, "Total authors on file: " + uniqueUserIds.size());
        this.logger.log(3, "Total authors found: " + outputMap.size());
        this.logger.log(3, "Total authors not found: " + (uniqueUserIds.size() - outputMap.size()));
        return this.createOutputData(outputMap);
    }

    private Map<String, Table> getAuthorCitations(Set<String> userIds) throws AlgorithmExecutionException {
        HashMap<String, Table> outputMap = new HashMap<String, Table>();
        for (String userId : userIds) {
            try {
                Table citationTable = CitationTableExtractor.getAuthorCitation(userId);
                outputMap.put(userId, citationTable);
            }
            catch (Exception exception) {
                this.logger.log(3, String.valueOf(userId) + ": Citation not found for the given user ID!!");
            }
        }
        return outputMap;
    }

    private Data[] createOutputData(Map<String, Table> outputMap) {
        ArrayList<Data> outputDataList = new ArrayList<Data>();
        for (String userId : outputMap.keySet()) {
            String label = "Citation Table: " + userId;
            Data outputData = DataFactory.forObject((Object)outputMap.get(userId), (String)Table.class.getName(), (String)"Table", (Data)this.data[0], (String)label);
            outputDataList.add(outputData);
        }
        return outputDataList.toArray(new Data[0]);
    }

    public static class Factory
    extends AbstractCitationAlgorithmFactory {
        @Override
        protected Algorithm createAlgorithm(Data[] data, String authorColumnName, String delimiter, CIShellContext ciShellContext) {
            return new CitationTableAlgorithm(data, authorColumnName, delimiter, ciShellContext);
        }
    }
}

