/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.googlescholar;

import edu.iu.sci2.reader.googlescholar.AbstractCitationAlgorithmFactory;
import edu.iu.sci2.reader.googlescholar.search.AuthorSearch;
import edu.iu.sci2.reader.googlescholar.search.GoogleScholarReaderHelper;
import java.util.Set;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.Data;
import org.cishell.utilities.DataFactory;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class GoogleCitationUserIdSearchAlgorithm
implements Algorithm {
    private Data[] data;
    private LogService logger;
    private String authorColumnName;
    private String delimiter;

    public GoogleCitationUserIdSearchAlgorithm(Data[] data, String authorColumnName, String delimiter, CIShellContext ciShellContext) {
        this.data = data;
        this.authorColumnName = authorColumnName;
        this.delimiter = delimiter;
        this.logger = (LogService)ciShellContext.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table table = (Table)this.data[0].getData();
        Set<String> uniqueAuthors = GoogleScholarReaderHelper.getUniqueAuthors(table, this.authorColumnName, this.delimiter, this.logger);
        AuthorSearch authorSearch = new AuthorSearch(uniqueAuthors, this.logger);
        Table outputTable = authorSearch.getAuthorInformationTable();
        this.logger.log(3, "Total authors on file: " + (authorSearch.getCountSingleAuthorFound() + authorSearch.getCountMultipleAuthorFound() + authorSearch.getCountAuthorNotFound()));
        this.logger.log(3, "Total authors found(Exact match): " + authorSearch.getCountSingleAuthorFound());
        this.logger.log(3, "Total authors found(Not exact match): " + authorSearch.getCountMultipleAuthorFound());
        this.logger.log(3, "Total authors not found(No match): " + authorSearch.getCountAuthorNotFound());
        return this.prepareOutputData(outputTable);
    }

    private Data[] prepareOutputData(Table table) {
        Data[] outputData = new Data[]{DataFactory.forObject((Object)table, (String)Table.class.getName(), (String)"Table", (Data)this.data[0], (String)"Google Citation User Id")};
        return outputData;
    }

    public static class Factory
    extends AbstractCitationAlgorithmFactory {
        @Override
        protected Algorithm createAlgorithm(Data[] data, String authorColumnName, String delimiter, CIShellContext ciShellContext) {
            return new GoogleCitationUserIdSearchAlgorithm(data, authorColumnName, delimiter, ciShellContext);
        }
    }
}

