/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.googlescholar.citationindicies;

import edu.iu.sci2.reader.googlescholar.citationindicies.IndicesRecord;
import edu.iu.sci2.reader.googlescholar.search.GoogleScholarReaderHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.cishell.utilities.network.DownloadHandler;

public final class AuthorIndicesExtractor {
    private static final String GCR_EXPORT_INDICES_URL_PREFIX = "http://www.scholar.google.com/citations?user=";
    private static final String GCR_EXPORT_INDICES_URL_POSTFIX = "&hl=en";
    private static final int INDICES_COLUMN_SIZE = 3;

    private AuthorIndicesExtractor() {
    }

    private static IndicesRecord getIndices(InputStream iStream, String userId) throws BadLocationException, IOException {
        Element element;
        ArrayList<String[]> indices = new ArrayList<String[]>();
        HTMLEditorKit htmlEditorkit = new HTMLEditorKit();
        HTMLDocument htmlDocument = (HTMLDocument)htmlEditorkit.createDefaultDocument();
        htmlDocument.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        BufferedReader bReader = new BufferedReader(new InputStreamReader(iStream));
        htmlEditorkit.read(bReader, (Document)htmlDocument, 0);
        ElementIterator iterator = new ElementIterator(htmlDocument);
        String[] indiceRow = null;
        while ((element = iterator.next()) != null) {
            String id;
            if (!element.getName().equals("table") || (id = (String)element.getAttributes().getAttribute(HTML.Attribute.ID)) == null || !id.equals("stats")) continue;
            int i = 1;
            while (i < element.getElementCount()) {
                Element trElement = element.getElement(i);
                int index = 1;
                int j = 0;
                while (j < trElement.getElementCount()) {
                    Element tdElement = trElement.getElement(j);
                    String tdClass = (String)tdElement.getAttributes().getAttribute(HTML.Attribute.CLASS);
                    if (tdClass != null && tdClass.equals("cit-caption")) {
                        String rowName = htmlDocument.getText(tdElement.getStartOffset(), tdElement.getEndOffset() - tdElement.getStartOffset());
                        if (!rowName.equals("")) {
                            indiceRow = new String[3];
                            indiceRow[0] = rowName.trim();
                        }
                    } else if (tdClass != null && tdClass.equals("cit-borderleft cit-data")) {
                        String value = htmlDocument.getText(tdElement.getStartOffset(), tdElement.getEndOffset() - tdElement.getStartOffset());
                        if (indiceRow != null && index <= 2) {
                            indiceRow[index++] = value.trim();
                        }
                    }
                    ++j;
                }
                indices.add(indiceRow);
                ++i;
            }
        }
        return AuthorIndicesExtractor.createIndicesRecord(userId, indices);
    }

    private static IndicesRecord createIndicesRecord(String userId, List<String[]> indices) {
        String citations = null;
        String citationsSince2007 = null;
        String hIndex = null;
        String hIndexSince2007 = null;
        String i10Index = null;
        String i10IndexSince2007 = null;
        for (String[] indiceRow : indices) {
            System.out.println(indiceRow[0]);
            if (indiceRow[0].equals("Citations")) {
                citations = indiceRow[1];
                citationsSince2007 = indiceRow[2];
                continue;
            }
            if (indiceRow[0].equals("h-index")) {
                hIndex = indiceRow[1];
                hIndexSince2007 = indiceRow[2];
                continue;
            }
            if (!indiceRow[0].equals("i10-index")) continue;
            i10Index = indiceRow[1];
            i10IndexSince2007 = indiceRow[2];
        }
        return new IndicesRecord(userId, citations, citationsSince2007, hIndex, hIndexSince2007, i10Index, i10IndexSince2007);
    }

    public static IndicesRecord getAuthorIndices(String userId) throws IndexExtractionException, IOException, DownloadHandler.InvalidUrlException, DownloadHandler.NetworkConnectionException {
        try {
            InputStream istream = AuthorIndicesExtractor.downloadIndicePage(userId.trim());
            return AuthorIndicesExtractor.getIndices(istream, userId);
        }
        catch (BadLocationException e) {
            throw new IndexExtractionException("The author indicies could not be extracted.", e);
        }
    }

    private static InputStream downloadIndicePage(String userId) throws IOException, DownloadHandler.InvalidUrlException, DownloadHandler.NetworkConnectionException {
        URL url = new URL(GCR_EXPORT_INDICES_URL_PREFIX + userId + GCR_EXPORT_INDICES_URL_POSTFIX);
        return GoogleScholarReaderHelper.connect(url);
    }

    public static class IndexExtractionException
    extends Exception {
        private static final long serialVersionUID = 8533261728213137711L;

        public IndexExtractionException(String message, Throwable reason) {
            super(message, reason);
        }
    }
}

