/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.googlescholar.citationindicies;

import edu.iu.sci2.reader.googlescholar.citationindicies.IndicesRecord;
import prefuse.data.Table;

public class IndicesRecordTable {
    public static final String USER_ID_COLUMN_NAME = "Citation User ID";
    public static final String CITATIONS_COLUMN_NAME = "Citations";
    public static final String CITATIONS_SINCE_2007_COLUMN_NAME = "Citations since 2007";
    public static final String H_INDEX_COLUMN_NAME = "h-index";
    public static final String H_INDEX_SINCE_2007_COLUMN_NAME = "h-index since 2007";
    public static final String I10_INDEX_COLUMN_NAME = "i10-index";
    public static final String I10_INDEX_SINCE_2007_COLUMN_NAME = "i10-index since 2007";
    private Table table = this.createTable();

    private Table createTable() {
        Table table = new Table();
        table.addColumn(USER_ID_COLUMN_NAME, String.class);
        table.addColumn(CITATIONS_COLUMN_NAME, String.class);
        table.addColumn(CITATIONS_SINCE_2007_COLUMN_NAME, String.class);
        table.addColumn(H_INDEX_COLUMN_NAME, String.class);
        table.addColumn(H_INDEX_SINCE_2007_COLUMN_NAME, String.class);
        table.addColumn(I10_INDEX_COLUMN_NAME, String.class);
        table.addColumn(I10_INDEX_SINCE_2007_COLUMN_NAME, String.class);
        return table;
    }

    public Table getTable() {
        return this.table;
    }

    public void addIndicesRecord(IndicesRecord record) {
        int rowIndex = this.table.addRow();
        this.setGoogleCitationUserId(rowIndex, record.getUserId());
        this.setCitations(rowIndex, record.getCitations());
        this.setCitationsSince2007(rowIndex, record.getCitationsSince2007());
        this.setHIndex(rowIndex, record.getHIndex());
        this.setHIndexSince2007(rowIndex, record.getHIndexSince2007());
        this.setI10Index(rowIndex, record.getI10Index());
        this.setI10IndexSince2007(rowIndex, record.getI10IndexSince2007());
    }

    private void setGoogleCitationUserId(int rowIndex, String userId) {
        this.table.setString(rowIndex, USER_ID_COLUMN_NAME, userId);
    }

    private void setCitations(int rowIndex, String value) {
        this.table.setString(rowIndex, CITATIONS_COLUMN_NAME, value);
    }

    private void setCitationsSince2007(int rowIndex, String value) {
        this.table.setString(rowIndex, CITATIONS_SINCE_2007_COLUMN_NAME, value);
    }

    private void setHIndex(int rowIndex, String value) {
        this.table.setString(rowIndex, H_INDEX_COLUMN_NAME, value);
    }

    private void setHIndexSince2007(int rowIndex, String value) {
        this.table.setString(rowIndex, H_INDEX_SINCE_2007_COLUMN_NAME, value);
    }

    private void setI10Index(int rowIndex, String value) {
        this.table.setString(rowIndex, I10_INDEX_COLUMN_NAME, value);
    }

    private void setI10IndexSince2007(int rowIndex, String value) {
        this.table.setString(rowIndex, I10_INDEX_SINCE_2007_COLUMN_NAME, value);
    }
}

