/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.googlescholar.citationtable;

import edu.iu.sci2.reader.googlescholar.citationtable.CitationRecord;
import prefuse.data.Table;

public class CitationRecordTable {
    private Table table;
    private static final String TITLE_COLUMN_NAME = "Title";
    private static final String AUTHOR_COLUMN_NAME = "Author";
    private static final String CITED_BY_COLUMN_NAME = "Cited by";
    private static final String YEAR_COLUMN_NAME = "Year";

    public CitationRecordTable() {
        this.createTable();
    }

    private void createTable() {
        this.table = new Table();
        this.table.addColumn(TITLE_COLUMN_NAME, String.class);
        this.table.addColumn(AUTHOR_COLUMN_NAME, String.class);
        this.table.addColumn(CITED_BY_COLUMN_NAME, Integer.class);
        this.table.addColumn(YEAR_COLUMN_NAME, Integer.class);
    }

    public Table getTable() {
        return this.table;
    }

    public void addCitationRecord(CitationRecord record) {
        int rowIndex = this.table.addRow();
        this.setTitle(rowIndex, record.getTitle());
        this.setAuthors(rowIndex, record.getAuthors());
        this.setCitedBy(rowIndex, record.getCitedBy());
        this.setYear(rowIndex, record.getYear());
    }

    private void setTitle(int rowIndex, String userId) {
        this.table.set(rowIndex, TITLE_COLUMN_NAME, (Object)userId);
    }

    private void setAuthors(int rowIndex, String value) {
        this.table.set(rowIndex, AUTHOR_COLUMN_NAME, (Object)value);
    }

    private void setCitedBy(int rowIndex, Integer value) {
        this.table.set(rowIndex, CITED_BY_COLUMN_NAME, (Object)value);
    }

    private void setYear(int rowIndex, Integer value) {
        this.table.set(rowIndex, YEAR_COLUMN_NAME, (Object)value);
    }
}

