/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.googlescholar.citationtable;

import edu.iu.sci2.reader.googlescholar.citationtable.CitationRecord;
import edu.iu.sci2.reader.googlescholar.citationtable.CitationRecordTable;
import edu.iu.sci2.reader.googlescholar.search.GoogleScholarReaderHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.cishell.utilities.network.DownloadHandler;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import prefuse.data.Table;

public final class CitationTableExtractor {
    private static final int PAGE_SIZE = 100;
    private static final int ASCII_0 = 48;
    private static final int ASCII_9 = 57;
    private static final String GCR_FETCH_CITATIONS_URL_1 = "http://scholar.google.com/citations?user=";
    private static final String GCR_FETCH_CITATIONS_NEXT_PAGE = "&hl=en&pagesize=100&view_op=list_works&cstart=";
    private static final String HTML_CITATION_TABLE_CLASS = "cit-table";
    private static final String HTML_CITATION_LINK_CLASS = "cit-dark-large-link";
    private static final String HTML_CITATION_GRAY_CLASS = "cit-gray";
    private static final String HTML_CITATION_TITLE_COLUMN_ID = "col-title";
    private static final String HTML_CITED_BY_COLUMN_ID = "col-citedby";
    private static final String HTML_YEAR_COLUMN_ID = "col-year";

    private CitationTableExtractor() {
    }

    public static Table getCitations(String userId) throws IOException, DownloadHandler.InvalidUrlException, DownloadHandler.NetworkConnectionException {
        int nextPageCitationsStart = 0;
        CitationRecordTable recordTable = new CitationRecordTable();
        URL url = CitationTableExtractor.getCitationPageURL(userId, nextPageCitationsStart);
        InputStream iStream = GoogleScholarReaderHelper.connect(url);
        boolean doneReading = iStream == null;
        while (!doneReading) {
            Document htmldoc = Jsoup.parse((InputStream)iStream, (String)"UTF-8", (String)url.toString());
            Elements table = htmldoc.getElementsByClass(HTML_CITATION_TABLE_CLASS);
            int i = 2;
            while (i < table.size()) {
                Element trElement = table.get(i);
                String title = trElement.getElementById(HTML_CITATION_TITLE_COLUMN_ID).getElementsByClass(HTML_CITATION_LINK_CLASS).text();
                Elements subElement = trElement.getElementById(HTML_CITATION_TITLE_COLUMN_ID).getElementsByClass(HTML_CITATION_GRAY_CLASS);
                String authors = subElement.first().text();
                Integer citedBy = 0;
                if (trElement.getElementById(HTML_CITED_BY_COLUMN_ID).hasText()) {
                    citedBy = Integer.parseInt(CitationTableExtractor.removeInvalidCharInNumber(trElement.getElementById(HTML_CITED_BY_COLUMN_ID).text()));
                }
                Integer year = 0;
                if (trElement.getElementById(HTML_YEAR_COLUMN_ID).hasText()) {
                    year = Integer.parseInt(CitationTableExtractor.removeInvalidCharInNumber(trElement.getElementById(HTML_YEAR_COLUMN_ID).text()));
                }
                if (citedBy == 0) {
                    citedBy = null;
                }
                if (year == 0) {
                    year = null;
                }
                recordTable.addCitationRecord(new CitationRecord(title, authors, citedBy, year));
                ++i;
            }
            if (htmldoc.html().contains("Next")) {
                url = CitationTableExtractor.getCitationPageURL(userId, nextPageCitationsStart += 100);
                iStream = GoogleScholarReaderHelper.connect(url);
                continue;
            }
            doneReading = true;
        }
        return recordTable.getTable();
    }

    public static Table getAuthorCitation(String userId) throws IOException, DownloadHandler.InvalidUrlException, DownloadHandler.NetworkConnectionException {
        Table citationsTable = CitationTableExtractor.getCitations(userId);
        return citationsTable;
    }

    private static URL getCitationPageURL(String userId, int nextPageCitationsStart) throws MalformedURLException {
        String urllink = GCR_FETCH_CITATIONS_URL_1 + userId + GCR_FETCH_CITATIONS_NEXT_PAGE + nextPageCitationsStart;
        return new URL(urllink);
    }

    private static String removeInvalidCharInNumber(String numberText) {
        int i = 0;
        while (i < numberText.length()) {
            if (numberText.charAt(i) < '0' || numberText.charAt(i) > '9') {
                numberText = String.valueOf(numberText.substring(0, i)) + numberText.substring(i + 1);
            }
            ++i;
        }
        return numberText;
    }
}

