/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.googlescholar.search;

import edu.iu.sci2.reader.googlescholar.search.AuthorRecord;
import java.util.HashMap;
import java.util.Map;
import prefuse.data.Table;

public class AuthorRecordMergeTable {
    public static final String CITATION_USER_ID_COLUMN = "Citation User ID";
    public static final String QUERIED_NAME_COLUMN = "Queried Name";
    public static final String AUTHOR_COLUMN = "Author";
    public static final String UNIVERSITY_COLUMN = "University";
    public static final String EMAIL_COLUMN = "Verified email";
    public static final String CITED_BY_COLUMN = "Cited by";
    public static final String UNIQUE_INDEX_COLUMN = "Unique Index";
    public static final String COMBINE_VALUE_COLUMN = "Combine Values";
    private Table table = this.createTable();
    private int uniqueIndex = 0;
    private Map<String, Integer> identifierToIndexMap = new HashMap<String, Integer>();

    private Table createTable() {
        Table table = new Table();
        table.addColumn(CITATION_USER_ID_COLUMN, String.class);
        table.addColumn(QUERIED_NAME_COLUMN, String.class);
        table.addColumn(AUTHOR_COLUMN, String.class);
        table.addColumn(UNIVERSITY_COLUMN, String.class);
        table.addColumn(EMAIL_COLUMN, String.class);
        table.addColumn(CITED_BY_COLUMN, String.class);
        table.addColumn(UNIQUE_INDEX_COLUMN, String.class);
        table.addColumn(COMBINE_VALUE_COLUMN, String.class);
        return table;
    }

    public Table getTable() {
        return this.table;
    }

    public void addAuthorRecord(String uniqueIndentifier, AuthorRecord record) {
        int rowIndex = this.table.addRow();
        int uniqueIdentifierIndex = this.getUniqueIdentifierIndex(rowIndex, uniqueIndentifier);
        this.setUniqueIndex(rowIndex, uniqueIdentifierIndex);
        this.setAuthor(rowIndex, record.getName());
        this.setUniversity(rowIndex, record.getUniversity());
        this.setEmail(rowIndex, record.getEmail());
        this.setCitedBy(rowIndex, record.getUserId());
        this.setQueriedAuthor(rowIndex, record.getQueriedAuthor());
        this.setGoogleCitationUserId(rowIndex, record.getUserId());
    }

    private int getUniqueIdentifierIndex(int rowIndex, String uniqueIndentifier) {
        if (!this.identifierToIndexMap.containsKey(uniqueIndentifier)) {
            this.identifierToIndexMap.put(uniqueIndentifier, ++this.uniqueIndex);
            this.setCombinedValue(rowIndex);
        }
        return this.identifierToIndexMap.get(uniqueIndentifier);
    }

    private void setGoogleCitationUserId(int rowIndex, String userId) {
        this.table.setString(rowIndex, CITATION_USER_ID_COLUMN, userId);
    }

    private void setQueriedAuthor(int rowIndex, String queriedAuthor) {
        this.table.setString(rowIndex, QUERIED_NAME_COLUMN, queriedAuthor);
    }

    private void setAuthor(int rowIndex, String authorName) {
        this.table.setString(rowIndex, AUTHOR_COLUMN, authorName);
    }

    private void setUniversity(int rowIndex, String universityName) {
        this.table.setString(rowIndex, UNIVERSITY_COLUMN, universityName);
    }

    private void setEmail(int rowIndex, String email) {
        this.table.setString(rowIndex, EMAIL_COLUMN, email);
    }

    private void setCitedBy(int rowIndex, String citationNumber) {
        this.table.setString(rowIndex, CITED_BY_COLUMN, citationNumber);
    }

    private void setUniqueIndex(int rowIndex, int uniqueIdentifierIndex) {
        this.table.setString(rowIndex, UNIQUE_INDEX_COLUMN, String.valueOf(uniqueIdentifierIndex));
    }

    private void setCombinedValue(int rowIndex) {
        this.table.setString(rowIndex, COMBINE_VALUE_COLUMN, "*");
    }
}

