/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.googlescholar.search;

import edu.iu.sci2.reader.googlescholar.search.AuthorRecord;
import edu.iu.sci2.reader.googlescholar.search.AuthorRecordMergeTable;
import edu.iu.sci2.reader.googlescholar.search.GoogleScholarReaderHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.cishell.utilities.network.DownloadHandler;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class AuthorSearch {
    private int countSingleAuthorFound = 0;
    private int countMultipleAuthorFound = 0;
    private int countAuthorNotFound = 0;
    private Table authorInformationTable = null;

    public AuthorSearch(Set<String> uniqueAuthors, LogService logger) {
        this.authorInformationTable = this.getAuthorInformation(uniqueAuthors, logger);
    }

    private Table getAuthorInformation(Set<String> uniqueAuthors, LogService logger) {
        AuthorRecordMergeTable mergeTable = new AuthorRecordMergeTable();
        for (String authorName : uniqueAuthors) {
            Collection<AuthorRecord> resultAuthorList = AuthorSearch.searchMatchedAuthors(authorName);
            if (resultAuthorList.isEmpty()) {
                logger.log(3, "Author '" + authorName + "' was not found.");
                ++this.countAuthorNotFound;
                continue;
            }
            if (resultAuthorList.size() == 1) {
                ++this.countSingleAuthorFound;
            } else {
                ++this.countMultipleAuthorFound;
            }
            for (AuthorRecord record : resultAuthorList) {
                mergeTable.addAuthorRecord(authorName, record);
            }
        }
        return mergeTable.getTable();
    }

    private static Collection<AuthorRecord> searchMatchedAuthors(String authorName) {
        try {
            return GoogleScholarReaderHelper.searchAuthor(authorName);
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
        catch (DownloadHandler.InvalidUrlException invalidUrlException) {
            return Collections.emptyList();
        }
        catch (DownloadHandler.NetworkConnectionException networkConnectionException) {
            return Collections.emptyList();
        }
    }

    public Table getAuthorInformationTable() {
        return this.authorInformationTable;
    }

    public int getCountSingleAuthorFound() {
        return this.countSingleAuthorFound;
    }

    public int getCountMultipleAuthorFound() {
        return this.countMultipleAuthorFound;
    }

    public int getCountAuthorNotFound() {
        return this.countAuthorNotFound;
    }
}

