/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.googlescholar.search;

import edu.iu.sci2.reader.googlescholar.search.AuthorRecord;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.cishell.utilities.network.DownloadHandler;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.log.LogService;
import prefuse.data.Table;
import prefuse.data.Tuple;

public final class GoogleScholarReaderHelper {
    private static final String GCR_SEARCH_AUTHOR_URL = "http://scholar.google.com/citations?hl=en&view_op=search_authors&mauthors=";
    private static final int USER_URL_START_INDEX = 16;
    private static final int USER_URL_END_INDEX = 28;
    private static final String EMAIL_INFO = "Verified email at";
    private static final String CITED_INFO = "Cited by";
    private static final String AUTHOR_ELEMENT_CLASS = "cit-dark-large-link";

    private GoogleScholarReaderHelper() {
    }

    public static Collection<AuthorRecord> searchAuthor(String authorName) throws IOException, DownloadHandler.InvalidUrlException, DownloadHandler.NetworkConnectionException {
        String encodedAuthorName = authorName.trim().replace(" ", "+");
        URL url = new URL(GCR_SEARCH_AUTHOR_URL + encodedAuthorName);
        InputStream iStream = GoogleScholarReaderHelper.connect(url);
        Document htmldoc = Jsoup.parse((InputStream)iStream, (String)"UTF-8", (String)url.toString());
        Elements authorElements = htmldoc.getElementsByClass(AUTHOR_ELEMENT_CLASS);
        ArrayList<AuthorRecord> records = new ArrayList<AuthorRecord>();
        int i = 0;
        while (i < authorElements.size()) {
            Element authorElement = authorElements.get(i);
            String name = GoogleScholarReaderHelper.getAuthorName(authorElement);
            String userId = GoogleScholarReaderHelper.getUserId(authorElement);
            String authorInfo = authorElement.parent().text();
            authorInfo = authorInfo.replace(String.valueOf(name) + " ", "");
            int emailIndex = authorInfo.indexOf(EMAIL_INFO);
            int citedByIndex = authorInfo.indexOf(CITED_INFO);
            String university = GoogleScholarReaderHelper.getUniversity(authorInfo, emailIndex);
            String email = GoogleScholarReaderHelper.getEmail(authorInfo, emailIndex, citedByIndex);
            String citedBy = GoogleScholarReaderHelper.getCitedBy(authorInfo, citedByIndex);
            AuthorRecord record = new AuthorRecord(name, userId, university, email, citedBy, authorName);
            records.add(record);
            ++i;
        }
        return records;
    }

    public static InputStream connect(URL url) throws IOException, DownloadHandler.InvalidUrlException, DownloadHandler.NetworkConnectionException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setAllowUserInteraction(false);
        connection.setDoOutput(true);
        connection.addRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        DownloadHandler.startConnect((HttpURLConnection)connection);
        return connection.getInputStream();
    }

    public static Set<String> getUniqueAuthors(Table table, String authorColumnName, String delimiter, LogService logger) {
        HashSet<String> uniqueAuthors = new HashSet<String>();
        Iterator rows = table.tuples();
        while (rows.hasNext()) {
            String[] authorNames;
            Tuple row = (Tuple)rows.next();
            if (!row.canGetString(authorColumnName)) continue;
            String authorString = row.getString(authorColumnName);
            if (delimiter == null) {
                uniqueAuthors.add(authorString);
                continue;
            }
            String escapedDelimiter = "\\" + delimiter;
            String[] stringArray = authorNames = authorString.split(escapedDelimiter);
            int n = authorNames.length;
            int n2 = 0;
            while (n2 < n) {
                String authorName = stringArray[n2];
                uniqueAuthors.add(authorName);
                ++n2;
            }
        }
        return uniqueAuthors;
    }

    private static String getAuthorName(Element authorElement) {
        return authorElement.text().trim();
    }

    private static String getUserId(Element authorElement) {
        String userIdUrL = authorElement.attr("href");
        String userId = userIdUrL.substring(userIdUrL.indexOf("/citations?user=") + 16, userIdUrL.indexOf("/citations?user=") + 28);
        return userId;
    }

    private static String getEmail(String authorInfo, int emailIndex, int citedByIndex) {
        String email = null;
        if (emailIndex != -1 && citedByIndex != -1) {
            email = authorInfo.substring(emailIndex + EMAIL_INFO.length(), citedByIndex).trim();
        } else if (emailIndex != -1 && citedByIndex == -1) {
            email = authorInfo.substring(emailIndex + EMAIL_INFO.length(), authorInfo.length()).trim();
        }
        return email;
    }

    private static String getCitedBy(String authorInfo, int citedByIndex) {
        String citedBy = null;
        if (citedByIndex != -1) {
            citedBy = authorInfo.substring(citedByIndex + CITED_INFO.length(), authorInfo.length()).trim();
        }
        return citedBy;
    }

    private static String getUniversity(String authorInfo, int emailIndex) {
        if (emailIndex == -1) {
            return authorInfo;
        }
        return authorInfo.substring(0, emailIndex).trim();
    }
}

