/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.reader.twitter;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;
import prefuse.data.Table;
import prefuse.data.util.TableIterator;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterReader
implements Algorithm {
    public static final String USER_COLUMN_TITLE = "Twitter User";
    public static final String USER_NAME_COLUMN_TITLE = "Twitter User Name";
    public static final String CREATED_AT_COLUMN_TITLE = "Created At";
    public static final String MSG_COLUMN_TITLE = "Tweet";
    private static final String CONSUMER_KEY = "consumerKey";
    private static final String CONSUMER_SECRET = "consumerSecret";
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String ACCESS_SECRET = "accessSecret";
    private LogService logger;
    private Data[] data;
    private String userIDColumn;
    private HashMap<String, String> authData;
    private String tag;
    private String propertyFile;

    public TwitterReader(Data[] data, Dictionary<String, Object> parameters, String propertyFile, CIShellContext ciShellContext) {
        this.logger = (LogService)ciShellContext.getService(LogService.class.getName());
        this.data = data;
        this.userIDColumn = parameters.get("uid").toString();
        this.tag = parameters.get("tag").toString();
        this.propertyFile = propertyFile;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table resultTable;
        try {
            this.authData = this.getAuthData(this.propertyFile);
        }
        catch (IOException iOException) {
            throw new AlgorithmExecutionException("The given property file is invalid!");
        }
        Set<String> userIDs = this.extractUniqueUserIDsFromTable();
        try {
            resultTable = this.searchTweet(userIDs);
        }
        catch (TwitterException e) {
            throw new AlgorithmExecutionException("Twitter service or network is unavailable. Try again later.", (Throwable)e);
        }
        return this.generateOutputData(resultTable);
    }

    private HashMap<String, String> getAuthData(String filePath) throws IOException {
        HashMap<String, String> arr = new HashMap<String, String>();
        Properties properties = new Properties();
        properties.load(new FileInputStream(filePath));
        arr.put(CONSUMER_KEY, properties.getProperty(CONSUMER_KEY));
        arr.put(CONSUMER_SECRET, properties.getProperty(CONSUMER_SECRET));
        arr.put(ACCESS_TOKEN, properties.getProperty(ACCESS_TOKEN));
        arr.put(ACCESS_SECRET, properties.getProperty(ACCESS_SECRET));
        return arr;
    }

    private Set<String> extractUniqueUserIDsFromTable() {
        HashSet<String> userIDs = new HashSet<String>();
        Table inputTable = (Table)this.data[0].getData();
        int userIDColumnIndex = inputTable.getColumnNumber(this.userIDColumn);
        TableIterator rowsIterator = inputTable.iterator();
        while (rowsIterator.hasNext()) {
            String userID;
            int currentRowNumber = Integer.parseInt(rowsIterator.next().toString());
            Object userIDObject = inputTable.get(currentRowNumber, userIDColumnIndex);
            if (!(userIDObject instanceof String) || (userID = userIDObject.toString().trim()) == null || userID.isEmpty()) continue;
            userIDs.add(userID);
        }
        return userIDs;
    }

    private Table searchTweet(Set<String> userIDs) throws TwitterException {
        ArrayList<Status> resultList = new ArrayList<Status>();
        String queryString = "#" + this.tag;
        if (!userIDs.isEmpty()) {
            queryString = String.valueOf(queryString) + " (";
            for (String id : userIDs) {
                String appendString = "from:\"" + id + "\" OR ";
                if (queryString.length() + appendString.length() >= 500) {
                    queryString = String.valueOf(queryString.substring(0, queryString.length() - 4)) + ")";
                    resultList.addAll(this.downloadAllTweets(queryString));
                    queryString = "#" + this.tag + " (";
                }
                queryString = String.valueOf(queryString) + appendString;
            }
            queryString = String.valueOf(queryString.substring(0, queryString.length() - 4)) + ")";
        }
        resultList.addAll(this.downloadAllTweets(queryString));
        return this.covertResultIntoTable(resultList);
    }

    private Twitter createTwitterInstance() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setDebugEnabled(true).setOAuthConsumerKey(this.authData.get(CONSUMER_KEY)).setOAuthConsumerSecret(this.authData.get(CONSUMER_SECRET)).setOAuthAccessToken(this.authData.get(ACCESS_TOKEN)).setOAuthAccessTokenSecret(this.authData.get(ACCESS_SECRET));
        return new TwitterFactory(cb.build()).getInstance();
    }

    private List<Status> downloadAllTweets(String querystring) throws TwitterException {
        ArrayList<Status> resultList = new ArrayList<Status>();
        Twitter twitter = this.createTwitterInstance();
        Query query = new Query(querystring);
        try {
            while (query != null) {
                query.setCount(100);
                QueryResult queryResult = twitter.search(query);
                List tweets = queryResult.getTweets();
                resultList.addAll(tweets);
                query = queryResult.nextQuery();
            }
        }
        catch (Exception exception) {
            this.logger.log(2, "You have reach the Twitter query limit (180 queries per 15 minutes). Please try again in 15 minutes.");
        }
        return resultList;
    }

    private Table covertResultIntoTable(List<Status> statuses) {
        Table table = new Table();
        table.addColumn(USER_COLUMN_TITLE, String.class);
        table.addColumn(USER_NAME_COLUMN_TITLE, String.class);
        table.addColumn(CREATED_AT_COLUMN_TITLE, Date.class);
        table.addColumn(MSG_COLUMN_TITLE, String.class);
        for (Status status : statuses) {
            int rowNumber = table.addRow();
            table.set(rowNumber, USER_COLUMN_TITLE, (Object)String.valueOf(status.getUser().getId()));
            table.set(rowNumber, USER_NAME_COLUMN_TITLE, (Object)status.getUser().getName());
            table.set(rowNumber, CREATED_AT_COLUMN_TITLE, (Object)status.getCreatedAt());
            table.set(rowNumber, MSG_COLUMN_TITLE, (Object)status.getText());
        }
        this.logger.log(3, String.format("%d tweets were downloaded.", statuses.size()));
        return table;
    }

    private Data[] generateOutputData(Table table) {
        BasicData output = new BasicData((Object)table, Table.class.getName());
        Dictionary metadata = output.getMetadata();
        metadata.put("Label", "TwitterResult");
        metadata.put("Parent", this.data[0]);
        metadata.put("Type", "Table");
        return new Data[]{output};
    }
}

